/*
 * Decompiled with CFR 0.152.
 */
package dashboard.util;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

public class CookieThenAcceptHeaderLocaleResolver
extends CookieLocaleResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CookieThenAcceptHeaderLocaleResolver.class);

    public void setLocaleContext(HttpServletRequest request, HttpServletResponse response, LocaleContext localeContext) {
        Cookie[] cookies;
        super.setLocaleContext(request, response, localeContext);
        Locale locale = (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
        if (locale != null && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!this.getCookieName().equals(cookie.getName())) continue;
                cookie.setValue(locale.toString());
                LOG.debug("Setting cookie name '{}' domain '{}' path '{}' value '{}'", new Object[]{cookie.getName(), cookie.getDomain(), cookie.getPath(), locale.toString()});
                response.addCookie(cookie);
            }
        }
    }
}

