/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.base.Strings;
import dashboard.control.BaseController;
import dashboard.control.RestResponse;
import dashboard.domain.ARP;
import dashboard.domain.Action;
import dashboard.domain.Category;
import dashboard.domain.CategoryValue;
import dashboard.domain.CoinUser;
import dashboard.domain.IdentityProvider;
import dashboard.domain.InstitutionIdentityProvider;
import dashboard.domain.LicenseStatus;
import dashboard.domain.Provider;
import dashboard.domain.Service;
import dashboard.domain.ServiceProvider;
import dashboard.manage.AuditData;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.service.ActionsService;
import dashboard.service.Services;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/dashboard/api/services"}, produces={"application/json"})
public class ServicesController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesController.class);
    @Autowired
    private Services services;
    @Autowired
    private Manage manage;
    @Autowired
    private ActionsService actionsService;
    @Value(value="${manage.manageBaseUrl}")
    private String manageBaseUrl;
    @Value(value="${dashboard.feature.stepup}")
    private boolean dashboardStepupEnabled;

    @GetMapping
    public RestResponse<Map<String, Object>> index(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale) throws IOException {
        List servicesForIdp = this.services.getServicesForIdp(idpEntityId, false, locale);
        List categories = this.getCategories(servicesForIdp);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("apps", servicesForIdp);
        result.put("facets", categories);
        return this.createRestResponse(result);
    }

    @RequestMapping(value={"/invitation-request-services"})
    public RestResponse<Map<String, Object>> invitationRequestServices(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale) throws IOException {
        List servicesForIdp = this.services.getServicesForIdp(idpEntityId, true, locale);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("apps", servicesForIdp);
        return this.createRestResponse(result);
    }

    private List<Category> getCategories(List<Service> servicesForIdp) {
        Map<String, List<Category>> groupedCategories = servicesForIdp.stream().map(s -> s.getCategories()).flatMap(Collection::stream).collect(Collectors.groupingBy(Category::getName));
        return groupedCategories.entrySet().stream().map(entry -> {
            List categoryValues = ((List)entry.getValue()).stream().flatMap(cat -> cat.getValues().stream().map(CategoryValue::getValue)).collect(Collectors.toSet()).stream().map(CategoryValue::new).collect(Collectors.toList());
            return new Category((String)entry.getKey(), "type_of_service", categoryValues);
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/connected"})
    public RestResponse<List<Service>> connected(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale) throws IOException {
        return this.createRestResponse(this.services.getServicesForIdp(idpEntityId, false, locale).stream().filter(Service::isConnected).collect(Collectors.toList()));
    }

    @PostMapping(value={"/by-entity-ids"})
    public RestResponse<List<Service>> byEnntityIds(@RequestBody List<String> entityIds, Locale locale) throws IOException {
        List servicesByEntityIds = this.services.getServicesByEntityIds(entityIds, locale);
        return this.createRestResponse((Object)servicesByEntityIds);
    }

    @RequestMapping(value={"/idps"})
    public RestResponse<List<InstitutionIdentityProvider>> getConnectedIdps(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam String spEntityId, @RequestParam String type) {
        ServiceProvider serviceProvider = (ServiceProvider)this.manage.getServiceProvider(spEntityId, EntityType.valueOf((String)type), false).orElseThrow(IllegalArgumentException::new);
        List idps = serviceProvider.isAllowedAll() ? this.manage.getLinkedIdentityProviders(spEntityId).stream().map(idp -> new InstitutionIdentityProvider(idp.getId(), idp.getName(Provider.Language.EN), idp.getName(Provider.Language.NL), idp.getInstitutionId(), idp.getState(), idp.getLogoUrl())).collect(Collectors.toList()) : serviceProvider.getAllowedEntityIds().stream().map(entityId -> this.manage.getIdentityProvider(entityId, false)).filter(Optional::isPresent).map(Optional::get).map(idp -> new InstitutionIdentityProvider(idp.getId(), idp.getName(Provider.Language.EN), idp.getName(Provider.Language.NL), idp.getInstitutionId(), idp.getState(), idp.getLogoUrl())).collect(Collectors.toList());
        return this.createRestResponse(idps);
    }

    @PostMapping(value={"/download"})
    public List<String[]> download(@RequestBody Map<String, Object> body, Locale locale) throws IOException {
        String idpEntityId = (String)body.get("idp");
        List ids = (List)body.get("ids");
        List services = this.services.getServicesForIdp(idpEntityId, false, locale);
        Stream<String[]> values = ids.stream().map(id -> this.getServiceById(services, Long.valueOf(id.longValue()))).flatMap(opt -> opt.map(Stream::of).orElse(Stream.empty())).map(service -> {
            LicenseStatus licenseStatus = service.getLicenseStatus();
            ARP arp = service.getArp();
            String[] stringArray = new String[14];
            stringArray[0] = String.valueOf(service.getId());
            stringArray[1] = this.stripBreakingWhitespace(service.getName());
            stringArray[2] = this.stripBreakingWhitespace(service.getOrganisation());
            stringArray[3] = service.getSpEntityId();
            stringArray[4] = this.stripBreakingWhitespace(service.getDescription());
            stringArray[5] = service.getAppUrl();
            stringArray[6] = service.getWikiUrl();
            stringArray[7] = service.getSupportMail();
            stringArray[8] = String.valueOf(service.isConnected());
            stringArray[9] = licenseStatus != null ? licenseStatus.name() : LicenseStatus.UNKNOWN.name();
            stringArray[10] = String.valueOf(service.isExampleSingleTenant());
            stringArray[11] = String.valueOf(service.isStrongAuthentication());
            stringArray[12] = String.valueOf(arp != null ? !arp.isNoArp() : false);
            stringArray[13] = arp != null ? arp.getAttributes().keySet().stream().collect(Collectors.joining(" - ")) : "";
            return stringArray;
        });
        Stream<String[]> headers = Stream.of(new String[]{"id", "name", "organisation-name", "entityID", "description", "app-url", "wiki-url", "support-mail", "connected", "licenseStatus", "singleTenant", "strongAuthentication", "arpEnabled", "arpAttributes"});
        List<String[]> rows = Stream.concat(headers, values).collect(Collectors.toList());
        return rows;
    }

    private String stripBreakingWhitespace(String input) {
        return StringUtils.hasText((String)input) ? input.trim().replaceAll("[\t\n\r;,]+", "") : "";
    }

    private Optional<Service> getServiceById(List<Service> services, Long id) {
        return services.stream().filter(service -> service.getId() == id.longValue()).findFirst();
    }

    @RequestMapping(value={"/detail"})
    public ResponseEntity<RestResponse<Service>> get(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam Long spId, @RequestParam String entityType, Locale locale) throws IOException {
        Optional serviceByEntityId = this.services.getServiceById(idpEntityId, spId, EntityType.valueOf((String)entityType), locale);
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        boolean eraseMails = currentUser.isGuest() || currentUser.isDashboardMember();
        return serviceByEntityId.map(service -> eraseMails ? ServicesController.eraseMailsFromService((Service)service) : service).map(service -> ResponseEntity.ok((Object)this.createRestResponse(service))).orElse(new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    public static Service eraseMailsFromService(Service service) {
        service.setSupportMail(null);
        service.setContactPersons(Collections.emptyList());
        return service;
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/connect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Action>> connect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="loaLevel", required=false) String loaLevel, @RequestParam(value="spEntityId") String spEntityId, @RequestParam(value="type") String type, @RequestParam(value="emailContactPerson", required=false) String emailContactPerson, Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.getCurrentLoaLevel() < 2 && this.dashboardStepupEnabled) {
            LOG.warn("Consent endpoint requires LOA level 2 or higher, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        return this.createAction(idpEntityId, comments, spEntityId, type, Action.Type.LINKREQUEST, locale, Optional.ofNullable(emailContactPerson), Optional.ofNullable(StringUtils.hasText((String)loaLevel) ? loaLevel : null)).map(action -> ResponseEntity.ok((Object)this.createRestResponse(action))).orElse(new ResponseEntity(HttpStatus.FORBIDDEN));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/disconnect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Action>> disconnect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="spEntityId") String spEntityId, @RequestParam(value="type") String type, Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.getCurrentLoaLevel() < 2 && this.dashboardStepupEnabled) {
            LOG.warn("Consent endpoint requires LOA level 2 or higher, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        return this.createAction(idpEntityId, comments, spEntityId, type, Action.Type.UNLINKREQUEST, locale, Optional.empty(), Optional.empty()).map(action -> ResponseEntity.ok((Object)this.createRestResponse(action))).orElse(new ResponseEntity(HttpStatus.FORBIDDEN));
    }

    private Optional<Action> createAction(String idpEntityId, String comments, String spEntityId, String typeMetaData, Action.Type jiraType, Locale locale, Optional<String> emailContactPersonOptional, Optional<String> loaLevel) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            LOG.warn(String.format("Action create not allowed, because of user %s ", currentUser));
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)currentUser.getIdp().getInstitutionId())) {
            LOG.warn(String.format("Action create not allowed, because of user IdP %s ", currentUser.getIdp()));
            return Optional.empty();
        }
        List services = this.services.getServicesForIdp(idpEntityId, false, locale);
        Optional<Service> optional = services.stream().filter(s -> s.getSpEntityId().equals(spEntityId)).findFirst();
        if (optional.isPresent()) {
            Service service = optional.get();
            boolean idpAndSpShareInstitution = service.getInstitutionId() != null && service.getInstitutionId().equals(currentUser.getIdp().getInstitutionId());
            boolean connectWithoutInteraction = idpAndSpShareInstitution || service.connectsWithoutInteraction();
            IdentityProvider identityProvider = (IdentityProvider)this.manage.getIdentityProvider(idpEntityId, false).orElseThrow(IllegalArgumentException::new);
            Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).body(comments).idpId(idpEntityId).spId(spEntityId).typeMetaData(typeMetaData).emailContactPerson(emailContactPersonOptional.orElse("")).connectWithoutInteraction(connectWithoutInteraction).shouldSendEmail(service.sendsEmailWithoutInteraction()).service(service).loaLevel((String)loaLevel.orElse(null)).type(jiraType).build();
            if (connectWithoutInteraction && Action.Type.LINKREQUEST.equals((Object)jiraType)) {
                return Optional.of(this.actionsService.connectWithoutInteraction(action, loaLevel));
            }
            List changeRequests = jiraType.equals((Object)Action.Type.LINKREQUEST) ? this.manage.createConnectionRequests(identityProvider, spEntityId, EntityType.valueOf((String)typeMetaData), loaLevel) : this.manage.deactivateConnectionRequests(identityProvider, spEntityId, EntityType.valueOf((String)typeMetaData));
            changeRequests.forEach(changeRequest -> {
                String metaDataId = changeRequest.getMetaDataId();
                String entityType = metaDataId.equals(identityProvider.getInternalId()) ? EntityType.saml20_idp.name() : typeMetaData;
                action.addManageUrl(String.format("%s/metadata/%s/%s/requests", this.manageBaseUrl, entityType, metaDataId));
            });
            action.addChangeRequests(changeRequests);
            Action jiraAction = this.actionsService.create(action);
            changeRequests.forEach(changeRequest -> {
                String ctx = jiraType.equals((Object)Action.Type.LINKREQUEST) ? "Connect" : "Disconnect";
                changeRequest.setAuditData(AuditData.context((String)String.format("%s SP %s", ctx, spEntityId), (String)jiraAction.getJiraKey()));
                this.manage.createChangeRequests(changeRequest);
            });
            return Optional.of(jiraAction);
        }
        return Optional.empty();
    }
}

