/*
 * Decompiled with CFR 0.152.
 */
package dashboard.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import dashboard.domain.CoinAuthority;
import dashboard.domain.IdentityProvider;
import dashboard.shibboleth.ShibbolethHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;

public class CoinUser
implements UserDetails {
    private String uid;
    private String displayName;
    private String givenName;
    private String surName;
    private String schacHomeOrganization;
    private IdentityProvider currentIdp;
    private IdentityProvider switchedToIdp;
    private int currentLoaLevel;
    private List<IdentityProvider> institutionIdps = new ArrayList();
    private String institutionId;
    private String email;
    private boolean manageConsentEnabled;
    private boolean dashboardStepupEnabled;
    private Set<CoinAuthority> grantedAuthorities = new HashSet();
    private Map<ShibbolethHeader, List<String>> attributeMap = new HashMap();
    private String hideTabs;
    private String supportedLanguages;
    private String organization;
    private boolean oidcEnabled;
    private boolean jiraDown;
    private boolean guest;
    private String defaultLoa;
    private List<String> loaLevels;
    private List<String> authnContextLevels;
    private Set<String> invitationRequestEntities = new HashSet();

    @JsonIgnore
    public String getPassword() {
        return "";
    }

    public String getUsername() {
        return this.uid;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSuperUser() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER));
    }

    public boolean isImpersonating() {
        return this.isSuperUser() && this.getSwitchedToIdp().isPresent() && this.isDashboardAdmin();
    }

    public boolean isDashboardAdmin() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
    }

    public boolean isDashboardViewer() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
    }

    public boolean isDashboardMember() {
        return this.hasAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_MEMBER));
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isGuest() {
        return this.guest;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getSurname() {
        return this.surName;
    }

    public void setSurName(String surName) {
        this.surName = surName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public void setSchacHomeOrganization(String schacHomeOrganization) {
        this.schacHomeOrganization = schacHomeOrganization;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedAuthorities;
    }

    public void setAuthorities(Set<CoinAuthority> grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
    }

    public void addAuthority(CoinAuthority grantedAuthority) {
        this.grantedAuthorities.add(grantedAuthority);
    }

    public void removeAuthority(CoinAuthority grantedAuthority) {
        this.grantedAuthorities.remove(grantedAuthority);
    }

    public boolean hasAuthority(CoinAuthority grantedAuthority) {
        return this.grantedAuthorities.contains(grantedAuthority);
    }

    public String getFriendlyName() {
        return StringUtils.hasText((String)this.displayName) ? this.displayName : this.uid;
    }

    public List<IdentityProvider> getInstitutionIdps() {
        return this.institutionIdps;
    }

    public void addInstitutionIdp(IdentityProvider idp) {
        this.institutionIdps.add(idp);
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public IdentityProvider getIdp() {
        return this.currentIdp;
    }

    public void setIdp(IdentityProvider idp) {
        this.currentIdp = idp;
    }

    public Optional<IdentityProvider> getSwitchedToIdp() {
        return Optional.ofNullable(this.switchedToIdp);
    }

    public void setSwitchedToIdp(IdentityProvider switchedToIdp) {
        this.switchedToIdp = switchedToIdp;
    }

    public Map<ShibbolethHeader, List<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<ShibbolethHeader, List<String>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void addAttribute(ShibbolethHeader key, List<String> value) {
        this.attributeMap.put(key, value);
    }

    public List<CoinAuthority.Authority> getAuthorityEnums() {
        return this.grantedAuthorities.stream().map(CoinAuthority::getEnumAuthority).collect(Collectors.toList());
    }

    public Optional<IdentityProvider> getByEntityId(String entityId) {
        return this.getInstitutionIdps().stream().filter(iip -> iip.getId().equals(entityId)).findFirst();
    }

    public boolean isManageConsentEnabled() {
        return this.manageConsentEnabled;
    }

    public void setManageConsentEnabled(boolean manageConsentEnabled) {
        this.manageConsentEnabled = manageConsentEnabled;
    }

    public void setHideTabs(String hideTabs) {
        this.hideTabs = hideTabs;
    }

    public boolean isOidcEnabled() {
        return this.oidcEnabled;
    }

    public void setOidcEnabled(boolean isOidcEnabled) {
        this.oidcEnabled = isOidcEnabled;
    }

    public String getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void setSupportedLanguages(String supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
    }

    public void setGuest(boolean guest) {
        this.guest = guest;
    }

    public String getHideTabs() {
        return this.hideTabs;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getDefaultLoa() {
        return this.defaultLoa;
    }

    public void setDefaultLoa(String defaultLoa) {
        this.defaultLoa = defaultLoa;
    }

    public List<String> getLoaLevels() {
        return this.loaLevels;
    }

    public void setLoaLevels(List<String> loaLevels) {
        this.loaLevels = loaLevels;
    }

    public List<String> getAuthnContextLevels() {
        return this.authnContextLevels;
    }

    public void setAuthnContextLevels(List<String> authnContextLevels) {
        this.authnContextLevels = authnContextLevels;
    }

    public Set<String> getInvitationRequestEntities() {
        return this.invitationRequestEntities;
    }

    public void setInvitationRequestEntities(Set<String> invitationRequestEntities) {
        this.invitationRequestEntities = invitationRequestEntities;
    }

    public IdentityProvider getCurrentIdp() {
        return this.currentIdp;
    }

    public int getCurrentLoaLevel() {
        return this.currentLoaLevel;
    }

    public void setCurrentLoaLevel(int currentLoaLevel) {
        this.currentLoaLevel = currentLoaLevel;
    }

    public boolean isDashboardStepupEnabled() {
        return this.dashboardStepupEnabled;
    }

    public void setDashboardStepupEnabled(boolean dashboardStepupEnabled) {
        this.dashboardStepupEnabled = dashboardStepupEnabled;
    }

    public boolean isJiraDown() {
        return this.jiraDown;
    }

    public void setJiraDown(boolean jiraDown) {
        this.jiraDown = jiraDown;
    }

    public String toString() {
        return "CoinUser(uid=" + this.getUid() + ", displayName=" + this.getDisplayName() + ", givenName=" + this.getGivenName() + ", surName=" + this.getSurname() + ", schacHomeOrganization=" + this.getSchacHomeOrganization() + ", currentIdp=" + String.valueOf(this.getCurrentIdp()) + ", switchedToIdp=" + String.valueOf(this.getSwitchedToIdp()) + ", currentLoaLevel=" + this.getCurrentLoaLevel() + ", institutionIdps=" + String.valueOf(this.getInstitutionIdps()) + ", institutionId=" + this.getInstitutionId() + ", email=" + this.getEmail() + ", manageConsentEnabled=" + this.isManageConsentEnabled() + ", dashboardStepupEnabled=" + this.isDashboardStepupEnabled() + ", grantedAuthorities=" + String.valueOf(this.grantedAuthorities) + ", attributeMap=" + String.valueOf(this.getAttributeMap()) + ", hideTabs=" + this.getHideTabs() + ", supportedLanguages=" + this.getSupportedLanguages() + ", organization=" + this.getOrganization() + ", oidcEnabled=" + this.isOidcEnabled() + ", jiraDown=" + this.isJiraDown() + ", guest=" + this.isGuest() + ", defaultLoa=" + this.getDefaultLoa() + ", loaLevels=" + String.valueOf(this.getLoaLevels()) + ", authnContextLevels=" + String.valueOf(this.getAuthnContextLevels()) + ", invitationRequestEntities=" + String.valueOf(this.getInvitationRequestEntities()) + ")";
    }
}

