/*
 * Decompiled with CFR 0.152.
 */
package dashboard.sab;

import dashboard.manage.Manage;
import dashboard.sab.Sab;
import dashboard.sab.SabPerson;
import dashboard.sab.SabRole;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SabRest
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabRest.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final String restEndPointURL;
    private final Manage manage;

    public SabRest(Manage manage, String sabRestUserName, String sabRestPassword, String restEndPointURL) {
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(sabRestUserName, sabRestPassword));
        this.restEndPointURL = restEndPointURL;
        this.manage = manage;
    }

    public List<SabPerson> getPersonsInRoleForOrganization(String organisationGuid, String role) {
        if (!StringUtils.hasText((String)organisationGuid)) {
            return Collections.emptyList();
        }
        String url = String.format("%s/profile?guid={organisationGuid}&role={role}", this.restEndPointURL);
        Map results = (Map)this.restTemplate.getForEntity(url, Map.class, new Object[]{organisationGuid, role}).getBody();
        LOG.debug("SAB results 'getPersonsInRoleForOrganization' for {} {} is {}", new Object[]{organisationGuid, role, results});
        List profiles = (List)results.get("profiles");
        return profiles.stream().map(profile -> {
            List sabRoles = ((List)profile.get("authorisations")).stream().map(authorisation -> new SabRole((String)authorisation.get("short"), (String)authorisation.get("role"))).collect(Collectors.toList());
            return new SabPerson((String)profile.get("firstname"), (String)profile.get("middlename"), (String)profile.get("surname"), (String)profile.get("uid"), (String)profile.get("email"), sabRoles);
        }).filter(p -> p.hasRole(role)).toList();
    }

    public List<SabPerson> getSabEmailsForOrganization(String entityId, String role) {
        Optional identityProviderOptional = this.manage.getIdentityProvider(entityId, false);
        return identityProviderOptional.map(identityProvider -> this.getPersonsInRoleForOrganization(identityProvider.getInstitutionId(), role)).orElse(Collections.emptyList());
    }
}

