/*
 * Decompiled with CFR 0.152.
 */
package dashboard.domain;

import dashboard.domain.Action;
import dashboard.domain.Consent;
import dashboard.domain.Service;
import dashboard.domain.Settings;
import dashboard.manage.ChangeRequest;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class Action {
    private String jiraKey;
    private String userName;
    private String userEmail;
    private String emailTo;
    private boolean shouldSendEmail;
    private boolean connectWithoutInteraction;
    private String body;
    private String personalMessage;
    private String emailContactPerson;
    private String idpId;
    private String spId;
    private Long spEid;
    private String idpName;
    private String spName;
    private String typeMetaData;
    private ZonedDateTime requestDate;
    private ZonedDateTime updateDate;
    private Type type;
    private String status;
    private String resolution;
    private Service service;
    private Settings settings;
    private Consent consent;
    private String loaLevel;
    private String mfaLevel;
    private List<String> manageUrls;
    private List<ChangeRequest> changeRequests;
    private boolean rejected;

    private Action(Builder builder) {
        this.jiraKey = builder.jiraKey;
        this.userName = builder.userName;
        this.userEmail = builder.userEmail;
        this.emailTo = builder.emailTo;
        this.shouldSendEmail = builder.shouldSendEmail;
        this.connectWithoutInteraction = builder.connectWithoutInteraction;
        this.body = builder.body;
        this.personalMessage = builder.personalMessage;
        this.emailContactPerson = builder.emailContactPerson;
        this.idpId = builder.idpId;
        this.spId = builder.spId;
        this.spEid = builder.spEid;
        this.spName = builder.spName;
        this.typeMetaData = builder.typeMetaData;
        this.idpName = builder.idpName;
        this.requestDate = builder.requestDate;
        this.updateDate = builder.updateDate;
        this.type = builder.type;
        this.status = builder.status;
        this.resolution = builder.resolution;
        this.service = builder.service;
        this.settings = builder.settings;
        this.consent = builder.consent;
        this.rejected = builder.rejected;
        this.loaLevel = builder.loaLevel;
        this.mfaLevel = builder.mfaLevel;
        this.manageUrls = builder.manageUrls;
    }

    public static Comparator<? super Action> sortByDateAsc() {
        return (a1, a2) -> new CompareToBuilder().append((Object)a1.getRequestDate(), (Object)a2.getRequestDate()).toComparison();
    }

    public Builder unbuild() {
        return new Builder(this);
    }

    public void addManageUrl(String manageUrl) {
        if (this.manageUrls == null) {
            this.manageUrls = new ArrayList();
        }
        this.manageUrls.add(manageUrl);
    }

    public void addChangeRequests(List<ChangeRequest> changeRequests) {
        this.changeRequests = changeRequests;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getJiraKey() {
        return this.jiraKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getEmailTo() {
        return this.emailTo;
    }

    public boolean isShouldSendEmail() {
        return this.shouldSendEmail;
    }

    public boolean isConnectWithoutInteraction() {
        return this.connectWithoutInteraction;
    }

    public String getBody() {
        return this.body;
    }

    public String getPersonalMessage() {
        return this.personalMessage;
    }

    public String getEmailContactPerson() {
        return this.emailContactPerson;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public String getSpId() {
        return this.spId;
    }

    public Long getSpEid() {
        return this.spEid;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public String getSpName() {
        return this.spName;
    }

    public String getTypeMetaData() {
        return this.typeMetaData;
    }

    public ZonedDateTime getRequestDate() {
        return this.requestDate;
    }

    public ZonedDateTime getUpdateDate() {
        return this.updateDate;
    }

    public Type getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResolution() {
        return this.resolution;
    }

    public Service getService() {
        return this.service;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Consent getConsent() {
        return this.consent;
    }

    public String getLoaLevel() {
        return this.loaLevel;
    }

    public String getMfaLevel() {
        return this.mfaLevel;
    }

    public List<String> getManageUrls() {
        return this.manageUrls;
    }

    public List<ChangeRequest> getChangeRequests() {
        return this.changeRequests;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isShouldSendEmail() != other.isShouldSendEmail()) {
            return false;
        }
        if (this.isConnectWithoutInteraction() != other.isConnectWithoutInteraction()) {
            return false;
        }
        if (this.isRejected() != other.isRejected()) {
            return false;
        }
        Long this$spEid = this.getSpEid();
        Long other$spEid = other.getSpEid();
        if (this$spEid == null ? other$spEid != null : !((Object)this$spEid).equals(other$spEid)) {
            return false;
        }
        String this$jiraKey = this.getJiraKey();
        String other$jiraKey = other.getJiraKey();
        if (this$jiraKey == null ? other$jiraKey != null : !this$jiraKey.equals(other$jiraKey)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$userEmail = this.getUserEmail();
        String other$userEmail = other.getUserEmail();
        if (this$userEmail == null ? other$userEmail != null : !this$userEmail.equals(other$userEmail)) {
            return false;
        }
        String this$emailTo = this.getEmailTo();
        String other$emailTo = other.getEmailTo();
        if (this$emailTo == null ? other$emailTo != null : !this$emailTo.equals(other$emailTo)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$personalMessage = this.getPersonalMessage();
        String other$personalMessage = other.getPersonalMessage();
        if (this$personalMessage == null ? other$personalMessage != null : !this$personalMessage.equals(other$personalMessage)) {
            return false;
        }
        String this$emailContactPerson = this.getEmailContactPerson();
        String other$emailContactPerson = other.getEmailContactPerson();
        if (this$emailContactPerson == null ? other$emailContactPerson != null : !this$emailContactPerson.equals(other$emailContactPerson)) {
            return false;
        }
        String this$idpId = this.getIdpId();
        String other$idpId = other.getIdpId();
        if (this$idpId == null ? other$idpId != null : !this$idpId.equals(other$idpId)) {
            return false;
        }
        String this$spId = this.getSpId();
        String other$spId = other.getSpId();
        if (this$spId == null ? other$spId != null : !this$spId.equals(other$spId)) {
            return false;
        }
        String this$idpName = this.getIdpName();
        String other$idpName = other.getIdpName();
        if (this$idpName == null ? other$idpName != null : !this$idpName.equals(other$idpName)) {
            return false;
        }
        String this$spName = this.getSpName();
        String other$spName = other.getSpName();
        if (this$spName == null ? other$spName != null : !this$spName.equals(other$spName)) {
            return false;
        }
        String this$typeMetaData = this.getTypeMetaData();
        String other$typeMetaData = other.getTypeMetaData();
        if (this$typeMetaData == null ? other$typeMetaData != null : !this$typeMetaData.equals(other$typeMetaData)) {
            return false;
        }
        ZonedDateTime this$requestDate = this.getRequestDate();
        ZonedDateTime other$requestDate = other.getRequestDate();
        if (this$requestDate == null ? other$requestDate != null : !((Object)this$requestDate).equals(other$requestDate)) {
            return false;
        }
        ZonedDateTime this$updateDate = this.getUpdateDate();
        ZonedDateTime other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$resolution = this.getResolution();
        String other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) {
            return false;
        }
        Service this$service = this.getService();
        Service other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        Consent this$consent = this.getConsent();
        Consent other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !this$consent.equals(other$consent)) {
            return false;
        }
        String this$loaLevel = this.getLoaLevel();
        String other$loaLevel = other.getLoaLevel();
        if (this$loaLevel == null ? other$loaLevel != null : !this$loaLevel.equals(other$loaLevel)) {
            return false;
        }
        String this$mfaLevel = this.getMfaLevel();
        String other$mfaLevel = other.getMfaLevel();
        if (this$mfaLevel == null ? other$mfaLevel != null : !this$mfaLevel.equals(other$mfaLevel)) {
            return false;
        }
        List this$manageUrls = this.getManageUrls();
        List other$manageUrls = other.getManageUrls();
        if (this$manageUrls == null ? other$manageUrls != null : !((Object)this$manageUrls).equals(other$manageUrls)) {
            return false;
        }
        List this$changeRequests = this.getChangeRequests();
        List other$changeRequests = other.getChangeRequests();
        return !(this$changeRequests == null ? other$changeRequests != null : !((Object)this$changeRequests).equals(other$changeRequests));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Action;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShouldSendEmail() ? 79 : 97);
        result = result * 59 + (this.isConnectWithoutInteraction() ? 79 : 97);
        result = result * 59 + (this.isRejected() ? 79 : 97);
        Long $spEid = this.getSpEid();
        result = result * 59 + ($spEid == null ? 43 : ((Object)$spEid).hashCode());
        String $jiraKey = this.getJiraKey();
        result = result * 59 + ($jiraKey == null ? 43 : $jiraKey.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $userEmail = this.getUserEmail();
        result = result * 59 + ($userEmail == null ? 43 : $userEmail.hashCode());
        String $emailTo = this.getEmailTo();
        result = result * 59 + ($emailTo == null ? 43 : $emailTo.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $personalMessage = this.getPersonalMessage();
        result = result * 59 + ($personalMessage == null ? 43 : $personalMessage.hashCode());
        String $emailContactPerson = this.getEmailContactPerson();
        result = result * 59 + ($emailContactPerson == null ? 43 : $emailContactPerson.hashCode());
        String $idpId = this.getIdpId();
        result = result * 59 + ($idpId == null ? 43 : $idpId.hashCode());
        String $spId = this.getSpId();
        result = result * 59 + ($spId == null ? 43 : $spId.hashCode());
        String $idpName = this.getIdpName();
        result = result * 59 + ($idpName == null ? 43 : $idpName.hashCode());
        String $spName = this.getSpName();
        result = result * 59 + ($spName == null ? 43 : $spName.hashCode());
        String $typeMetaData = this.getTypeMetaData();
        result = result * 59 + ($typeMetaData == null ? 43 : $typeMetaData.hashCode());
        ZonedDateTime $requestDate = this.getRequestDate();
        result = result * 59 + ($requestDate == null ? 43 : ((Object)$requestDate).hashCode());
        ZonedDateTime $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : $resolution.hashCode());
        Service $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        Consent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : $consent.hashCode());
        String $loaLevel = this.getLoaLevel();
        result = result * 59 + ($loaLevel == null ? 43 : $loaLevel.hashCode());
        String $mfaLevel = this.getMfaLevel();
        result = result * 59 + ($mfaLevel == null ? 43 : $mfaLevel.hashCode());
        List $manageUrls = this.getManageUrls();
        result = result * 59 + ($manageUrls == null ? 43 : ((Object)$manageUrls).hashCode());
        List $changeRequests = this.getChangeRequests();
        result = result * 59 + ($changeRequests == null ? 43 : ((Object)$changeRequests).hashCode());
        return result;
    }

    public String toString() {
        return "Action(jiraKey=" + this.getJiraKey() + ", userName=" + this.getUserName() + ", userEmail=" + this.getUserEmail() + ", emailTo=" + this.getEmailTo() + ", shouldSendEmail=" + this.isShouldSendEmail() + ", connectWithoutInteraction=" + this.isConnectWithoutInteraction() + ", body=" + this.getBody() + ", personalMessage=" + this.getPersonalMessage() + ", emailContactPerson=" + this.getEmailContactPerson() + ", idpId=" + this.getIdpId() + ", spId=" + this.getSpId() + ", spEid=" + this.getSpEid() + ", idpName=" + this.getIdpName() + ", spName=" + this.getSpName() + ", typeMetaData=" + this.getTypeMetaData() + ", requestDate=" + String.valueOf(this.getRequestDate()) + ", updateDate=" + String.valueOf(this.getUpdateDate()) + ", type=" + String.valueOf(this.getType()) + ", status=" + this.getStatus() + ", resolution=" + this.getResolution() + ", service=" + String.valueOf(this.getService()) + ", settings=" + String.valueOf(this.getSettings()) + ", consent=" + String.valueOf(this.getConsent()) + ", loaLevel=" + this.getLoaLevel() + ", mfaLevel=" + this.getMfaLevel() + ", manageUrls=" + String.valueOf(this.getManageUrls()) + ", changeRequests=" + String.valueOf(this.getChangeRequests()) + ", rejected=" + this.isRejected() + ")";
    }
}

