/*
 * Decompiled with CFR 0.152.
 */
package dashboard.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import dashboard.domain.CategoryValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Category
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String name;
    private String searchValue;
    private List<CategoryValue> values = new ArrayList();

    public Category() {
    }

    public Category(String name, String searchValue, List<CategoryValue> values) {
        this.name = name;
        this.searchValue = searchValue;
        this.values = values;
        this.values.sort(CategoryValue::compareTo);
    }

    public List<CategoryValue> getValues() {
        return this.values;
    }

    public void setValues(List<CategoryValue> values) {
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public void addCategoryValue(CategoryValue value) {
        this.values.add(value);
    }

    @JsonIgnore
    public boolean containsValue(String value) {
        return this.values.stream().anyMatch(cv -> cv.getValue().equals(value));
    }

    @JsonIgnore
    public boolean isUsedFacetValues() {
        return this.values.stream().anyMatch(cv -> cv.getCount() > 0);
    }

    public String getSearchValue() {
        return this.searchValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Category.class).add("name", (Object)this.name).add("values", (Object)this.values).toString();
    }
}

