/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import dashboard.ShibbolethSecurityConfig;
import dashboard.filter.EnsureAccessToIdpFilter;
import dashboard.manage.Manage;
import dashboard.sab.Sab;
import dashboard.service.impl.JiraClient;
import dashboard.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import dashboard.shibboleth.ShibbolethUserDetailService;
import dashboard.shibboleth.mock.MockShibbolethFilter;
import dashboard.shibboleth.mock.ShibbolethSSOFilter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class ShibbolethSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethSecurityConfig.class);
    @Autowired
    private Manage manage;
    @Autowired
    private Sab sab;
    @Autowired
    private JiraClient jiraClient;
    @Value(value="${dashboard.admin}")
    private String dashboardAdmin;
    @Value(value="${dashboard.viewer}")
    private String dashboardViewer;
    @Value(value="${dashboard.super.user}")
    private String dashboardSuperUser;
    @Value(value="${admin.surfconext.idp.sabRole}")
    private String adminSufConextIdpRole;
    @Value(value="${viewer.surfconext.idp.sabRole}")
    private String viewerSurfConextIdpRole;
    @Value(value="${dashboard.feature.shibboleth}")
    private boolean shibbolethEnabled;
    @Value(value="${dashboard.feature.consent}")
    private boolean isManageConsentEnabled;
    @Value(value="${dashboard.feature.oidc}")
    private boolean isOidcEnabled;
    @Value(value="${dashboard.feature.jiraDown}")
    private boolean jiraDown;
    @Value(value="${dashboard.hide_tabs}")
    private String hideTabs;
    @Value(value="${supported_language_codes}")
    private String supportedLanguages;
    @Value(value="${organization}")
    private String organization;
    @Value(value="${default_loa_level}")
    private String defaultLoa;
    @Value(value="${loa_values_supported}")
    private String loaLevels;
    @Value(value="${authn_context_levels}")
    private String authnContextLevels;
    @Value(value="${dashboard.feature.stepup}")
    private boolean dashboardStepupEnabled;

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/public/**", "/css/**", "/font/**", "/images/**", "/img/**", "/js/**", "/internal/**", "/info", "/health", "/serviceProvider/api/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        List loaLevels = Arrays.stream(this.loaLevels.replaceAll("\"", "").split(",")).map(String::trim).collect(Collectors.toList());
        List authnContextLevels = Arrays.stream(this.authnContextLevels.replaceAll("\"", "").split(",")).map(String::trim).collect(Collectors.toList());
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.logout().logoutUrl("/dashboard/api/logout").invalidateHttpSession(true).deleteCookies(new String[]{"statsToken"}).logoutSuccessHandler((LogoutSuccessHandler)new DashboardLogoutSuccessHandler()).addLogoutHandler((LogoutHandler)new DashboardLogoutHandler()).and()).csrf().disable()).addFilterBefore((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean(), this.manage, this.sab, this.jiraClient, this.dashboardAdmin, this.dashboardViewer, this.dashboardSuperUser, this.adminSufConextIdpRole, this.viewerSurfConextIdpRole, this.isManageConsentEnabled, this.isOidcEnabled, this.dashboardStepupEnabled, this.jiraDown, this.hideTabs, this.supportedLanguages, this.organization, this.defaultLoa, loaLevels, authnContextLevels), AbstractPreAuthenticatedProcessingFilter.class).addFilterAfter((Filter)new EnsureAccessToIdpFilter(this.manage), ShibbolethPreAuthenticatedProcessingFilter.class).authorizeRequests().antMatchers(new String[]{"/identity/**"})).hasRole("DASHBOARD_SUPER_USER").antMatchers(new String[]{"/dashboard/api/stats/**"})).hasAnyRole(new String[]{"DASHBOARD_ADMIN", "DASHBOARD_VIEWER", "DASHBOARD_MEMBER", "DASHBOARD_SUPER_USER"}).antMatchers(new String[]{"/dashboard/api/**"})).hasAnyRole(new String[]{"DASHBOARD_ADMIN", "DASHBOARD_VIEWER", "DASHBOARD_MEMBER", "DASHBOARD_SUPER_USER", "DASHBOARD_GUEST"}).anyRequest()).authenticated();
        if (!this.shibbolethEnabled) {
            http.addFilterBefore((Filter)new MockShibbolethFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
            http.addFilterAfter((Filter)new ShibbolethSSOFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        LOG.info("Configuring AuthenticationManager with a PreAuthenticatedAuthenticationProvider");
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }

    @Bean
    protected AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }
}

