/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import dashboard.control.EnrichJson;
import dashboard.control.ExcludeJsonIgnore;
import dashboard.control.GsonHttpMessageConverter;
import dashboard.control.RestResponse;
import dashboard.domain.CoinUser;
import dashboard.shibboleth.ShibbolethHeader;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class GsonHttpMessageConverter
extends AbstractHttpMessageConverter<RestResponse<?>> {
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExcludeJsonIgnore()}).enableComplexMapKeySerialization().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeTypeAdapter().nullSafe()).registerTypeAdapter(ShibbolethHeader.class, (Object)new ShibbolethHeaderTypeAdapter().nullSafe());
    private boolean statsEnabled;
    private Gson gson = GSON_BUILDER.create();

    public GsonHttpMessageConverter(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return clazz.isAssignableFrom(RestResponse.class) && mediaType != null && mediaType.equals((Object)MediaType.APPLICATION_JSON);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Arrays.asList(MediaType.APPLICATION_JSON);
    }

    protected boolean supports(Class<?> clazz) {
        return false;
    }

    protected RestResponse<?> readInternal(Class<? extends RestResponse<?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException("nyi");
    }

    protected void writeInternal(RestResponse<?> objectRestResponse, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonElement json = this.gson.toJsonTree(objectRestResponse);
        EnrichJson.forUser((boolean)this.statsEnabled, (CoinUser)SpringSecurity.getCurrentUser()).json(json).forPayload(objectRestResponse.getPayload());
        Charset charset = this.getCharset(outputMessage.getHeaders());
        try (OutputStreamWriter jsonWriter = new OutputStreamWriter(outputMessage.getBody(), charset);){
            this.gson.toJson(json, (Appendable)jsonWriter);
        }
        catch (JsonIOException e) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    private Charset getCharset(HttpHeaders headers) {
        if (headers == null || headers.getContentType() == null || headers.getContentType().getCharset() == null) {
            return StandardCharsets.UTF_8;
        }
        return headers.getContentType().getCharset();
    }
}

