/*
 * Decompiled with CFR 0.152.
 */
package dashboard.sab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dashboard.sab.Sab;
import dashboard.sab.SabPerson;
import dashboard.sab.SabRole;
import dashboard.sab.SabRoleHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SabClientMock
implements Sab {
    private static final SabRole ROLE_BEHEERDER = new SabRole("CONBEH", "SURFconextbeheerder");
    private static final SabRole ROLE_VERANTWOORDELIJKE = new SabRole("CONVER", "SURFconextverantwoordelijke");
    private final List<SabPerson> sabPersons = ImmutableList.of((Object)new SabPerson("Hans", "", "Janssen", "hjanssen", "hjanssen@surfnet.nl", Arrays.asList(ROLE_BEHEERDER)), (Object)new SabPerson("Raoul", "var der", "Teeuwen", "rteeuwen", "raoul.teeuwen@surfnet.nl", Arrays.asList(ROLE_VERANTWOORDELIJKE)), (Object)new SabPerson("Okke", "", "Harsta", "oharsta", "oharsta@zilverline.nl", Arrays.asList(ROLE_VERANTWOORDELIJKE)));
    private final Map<String, SabRoleHolder> rolesMapping;

    public SabClientMock() {
        this.rolesMapping = ImmutableMap.of((Object)"admin", (Object)new SabRoleHolder("SURFNET", Arrays.asList(SabClientMock.ROLE_VERANTWOORDELIJKE.roleName)), (Object)"viewer", (Object)new SabRoleHolder("SURFNET", Arrays.asList(SabClientMock.ROLE_BEHEERDER.roleName)), (Object)"noroles", (Object)new SabRoleHolder("SURFNET", Collections.emptyList()));
    }

    public List<SabPerson> getPersonsInRoleForOrganization(String organisationGuid, String role) {
        return this.sabPersons.stream().filter(person -> person.getRoles().stream().anyMatch(r -> r.roleName.equals(role))).toList();
    }

    public List<SabPerson> getSabEmailsForOrganization(String entityId, String role) {
        return this.getPersonsInRoleForOrganization(null, role);
    }
}

