/*
 * Decompiled with CFR 0.152.
 */
package dashboard.domain;

import dashboard.domain.ARP;
import dashboard.domain.LicenseStatus;
import dashboard.domain.PrivacyInfo;
import dashboard.domain.Provider;
import dashboard.manage.DashboardConnectOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ServiceProvider
extends Provider
implements Serializable,
Cloneable {
    private static final List<String> nameIdFormats = Arrays.asList("NameIDFormat", "NameIDFormats:0", "NameIDFormats:1", "NameIDFormats:2");
    private final Map<String, String> arpMotivations;
    private final Map<String, String> arpSources;
    private final String applicationUrl;
    private final String institutionId;
    private final String eulaURL;
    private final String interfedSource;
    private final String privacyStatementUrlEn;
    private final String privacyStatementUrlNl;
    private final String privacyStatementUrlPt;
    private final String registrationInfo;
    private final String registrationPolicyUrlEn;
    private final String registrationPolicyUrlNl;
    private final String registrationPolicyUrlPt;
    private final String entityCategories1;
    private final String entityCategories2;
    private final String entityCategories3;
    private final boolean idpVisibleOnly;
    private final boolean policyEnforcementDecisionRequired;
    private final DashboardConnectOption dashboardConnectOption;
    private final boolean aansluitovereenkomstRefused;
    private final boolean hidden;
    private final LicenseStatus licenseStatus;
    private final List<String> nameIds;
    private final List<String> resourceServers;
    private final boolean isResourceServer;
    private boolean isClientCredentials;
    private final boolean excludeFromPush;
    private final ARP arp;
    private final PrivacyInfo privacyInfo;
    private final Map<String, String> urls = new HashMap();
    private final String wikiUrlNl;
    private final String wikiUrlEn;
    private final String wikiUrlPt;
    private final boolean strongAuthenticationEnabled;
    private final String minimalLoaLevel;
    private List<String> typeOfServicesNl = new ArrayList();
    private List<String> typeOfServicesEn = new ArrayList();
    private List<String> typeOfServicesPt = new ArrayList();
    private final String manipulationNotes;
    private final boolean manipulation;
    private final String contractualBase;

    public ServiceProvider(Map<String, Object> metaData) {
        super(metaData);
        this.dashboardConnectOption = DashboardConnectOption.fromOption((String)((String)metaData.getOrDefault("coin:dashboard_connect_option", "connect_with_interaction")));
        this.applicationUrl = (String)metaData.get("coin:application_url");
        this.institutionId = (String)metaData.get("coin:institution_guid");
        this.eulaURL = (String)metaData.get("coin:eula");
        this.interfedSource = (String)metaData.getOrDefault("coin:interfed_source", "SURFconext");
        this.privacyStatementUrlEn = (String)metaData.get("mdui:PrivacyStatementURL:en");
        this.privacyStatementUrlNl = (String)metaData.get("mdui:PrivacyStatementURL:nl");
        this.privacyStatementUrlPt = (String)metaData.get("mdui:PrivacyStatementURL:pt");
        this.registrationInfo = (String)metaData.get("mdrpi:RegistrationInfo");
        this.registrationPolicyUrlEn = (String)metaData.get("mdrpi:RegistrationPolicy:en");
        this.registrationPolicyUrlNl = (String)metaData.get("mdrpi:RegistrationPolicy:nl");
        this.registrationPolicyUrlPt = (String)metaData.get("mdrpi:RegistrationPolicy:pt");
        this.entityCategories1 = (String)metaData.get("coin:entity_categories:1");
        this.entityCategories2 = (String)metaData.get("coin:entity_categories:2");
        this.entityCategories3 = (String)metaData.get("coin:entity_categories:3");
        this.licenseStatus = LicenseStatus.fromManage((String)((String)metaData.get("coin:ss:license_status")));
        this.idpVisibleOnly = this.booleanValue(metaData.get("coin:ss:idp_visible_only"));
        this.policyEnforcementDecisionRequired = this.booleanValue(metaData.get("coin:policy_enforcement_decision_required"));
        this.minimalLoaLevel = (String)metaData.get("coin:stepup:requireloa");
        this.strongAuthenticationEnabled = StringUtils.hasText((String)this.minimalLoaLevel);
        this.aansluitovereenkomstRefused = this.booleanValue(metaData.get("coin:ss:aansluitovereenkomst_refused"));
        this.excludeFromPush = this.booleanValue(metaData.get("coin:exclude_from_push"));
        this.hidden = this.booleanValue(metaData.get("coin:ss:hidden"));
        this.wikiUrlEn = (String)metaData.get("coin:ss:wiki_url:en");
        this.wikiUrlNl = (String)metaData.get("coin:ss:wiki_url:nl");
        this.wikiUrlPt = (String)metaData.get("coin:ss:wiki_url:pt");
        Object attributes = metaData.get("attributes");
        if (attributes != null) {
            if (attributes instanceof List) {
                Map<String, List> collect = ((List)attributes).stream().collect(Collectors.toMap(attr -> attr, attr -> Collections.singletonList("*")));
                this.arp = ARP.fromAttributes(collect);
            } else {
                this.arp = ARP.fromAttributes((Map)((Map)attributes));
            }
        } else {
            this.arp = ARP.noArp();
        }
        String typeOfService = (String)metaData.get("coin:ss:type_of_service:en");
        if (StringUtils.hasText((String)typeOfService)) {
            this.typeOfServicesEn = Arrays.asList(typeOfService.split(","));
        }
        if (StringUtils.hasText((String)(typeOfService = (String)metaData.get("coin:ss:type_of_service:nl")))) {
            this.typeOfServicesNl = Arrays.asList(typeOfService.split(","));
        }
        if (StringUtils.hasText((String)(typeOfService = (String)metaData.get("coin:ss:type_of_service:pt")))) {
            this.typeOfServicesPt = Arrays.asList(typeOfService.split(","));
        }
        this.addUrl("en", (String)metaData.get("url:en"));
        this.addUrl("nl", (String)metaData.get("url:nl"));
        this.addUrl("pt", (String)metaData.get("url:pt"));
        this.privacyInfo = this.buildPrivacyInfo(metaData);
        this.arpMotivations = (Map)metaData.get("motivations");
        this.arpSources = (Map)metaData.get("sources");
        this.manipulationNotes = (String)metaData.get("manipulationNotes");
        this.manipulation = StringUtils.hasText((String)((String)metaData.get("manipulation")));
        this.contractualBase = (String)metaData.getOrDefault("coin:contractual_base", "NA");
        this.nameIds = nameIdFormats.stream().filter(metaData::containsKey).map(nameId -> (String)metaData.get(nameId)).collect(Collectors.toList());
        this.resourceServers = (List)metaData.get("allowedResourceServers");
        this.isResourceServer = this.booleanValue(metaData.get("isResourceServer"));
        List grants = (List)metaData.get("grants");
        if (!CollectionUtils.isEmpty((Collection)grants) && grants.size() == 1 && ((String)grants.get(0)).equals("client_credentials")) {
            this.isClientCredentials = true;
        }
    }

    private PrivacyInfo buildPrivacyInfo(Map<String, Object> metaData) {
        return new PrivacyInfo((String)metaData.get("coin:privacy:what_data"), (String)metaData.get("coin:privacy:country"), (String)metaData.get("coin:privacy:access_data"), (String)metaData.get("coin:privacy:security_measures"), (String)metaData.get("mdui:PrivacyStatementURL:en"), (String)metaData.get("mdui:PrivacyStatementURL:nl"), (String)metaData.get("coin:privacy:dpa_type"), (String)metaData.get("coin:privacy:other_info"));
    }

    public String getUrl(Provider.Language language) {
        return CollectionUtils.isEmpty((Map)this.urls) ? null : (String)this.urls.get(language.name().toLowerCase());
    }

    public String getWikiUrl(Provider.Language language) {
        return Provider.Language.EN.equals((Object)language) ? this.wikiUrlEn : (Provider.Language.PT.equals((Object)language) ? this.wikiUrlPt : this.wikiUrlNl);
    }

    private void addUrl(String lang, String url) {
        if (StringUtils.hasText((String)url)) {
            this.urls.put(lang, url);
        }
    }

    public String toString() {
        return "ServiceProvider{id='" + this.getId() + "', applicationUrl='" + this.applicationUrl + "', institutionId='" + this.institutionId + "', eulaURL='" + this.eulaURL + "', idpVisibleOnly=" + this.idpVisibleOnly + ", policyEnforcementDecisionRequired=" + this.policyEnforcementDecisionRequired + ", entityType=" + String.valueOf(this.getEntityType()) + ", arp=" + String.valueOf(this.arp) + ", urls=" + String.valueOf(this.urls) + "}";
    }

    public ServiceProvider clone() {
        try {
            return (ServiceProvider)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getArpMotivations() {
        return this.arpMotivations;
    }

    public Map<String, String> getArpSources() {
        return this.arpSources;
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public String getEulaURL() {
        return this.eulaURL;
    }

    public String getInterfedSource() {
        return this.interfedSource;
    }

    public String getPrivacyStatementUrlEn() {
        return this.privacyStatementUrlEn;
    }

    public String getPrivacyStatementUrlNl() {
        return this.privacyStatementUrlNl;
    }

    public String getPrivacyStatementUrlPt() {
        return this.privacyStatementUrlPt;
    }

    public String getRegistrationInfo() {
        return this.registrationInfo;
    }

    public String getRegistrationPolicyUrlEn() {
        return this.registrationPolicyUrlEn;
    }

    public String getRegistrationPolicyUrlNl() {
        return this.registrationPolicyUrlNl;
    }

    public String getRegistrationPolicyUrlPt() {
        return this.registrationPolicyUrlPt;
    }

    public String getEntityCategories1() {
        return this.entityCategories1;
    }

    public String getEntityCategories2() {
        return this.entityCategories2;
    }

    public String getEntityCategories3() {
        return this.entityCategories3;
    }

    public boolean isIdpVisibleOnly() {
        return this.idpVisibleOnly;
    }

    public boolean isPolicyEnforcementDecisionRequired() {
        return this.policyEnforcementDecisionRequired;
    }

    public DashboardConnectOption getDashboardConnectOption() {
        return this.dashboardConnectOption;
    }

    public boolean isAansluitovereenkomstRefused() {
        return this.aansluitovereenkomstRefused;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public LicenseStatus getLicenseStatus() {
        return this.licenseStatus;
    }

    public List<String> getNameIds() {
        return this.nameIds;
    }

    public List<String> getResourceServers() {
        return this.resourceServers;
    }

    public boolean isResourceServer() {
        return this.isResourceServer;
    }

    public boolean isClientCredentials() {
        return this.isClientCredentials;
    }

    public boolean isExcludeFromPush() {
        return this.excludeFromPush;
    }

    public ARP getArp() {
        return this.arp;
    }

    public PrivacyInfo getPrivacyInfo() {
        return this.privacyInfo;
    }

    public Map<String, String> getUrls() {
        return this.urls;
    }

    public String getWikiUrlNl() {
        return this.wikiUrlNl;
    }

    public String getWikiUrlEn() {
        return this.wikiUrlEn;
    }

    public String getWikiUrlPt() {
        return this.wikiUrlPt;
    }

    public boolean isStrongAuthenticationEnabled() {
        return this.strongAuthenticationEnabled;
    }

    public String getMinimalLoaLevel() {
        return this.minimalLoaLevel;
    }

    public List<String> getTypeOfServicesNl() {
        return this.typeOfServicesNl;
    }

    public List<String> getTypeOfServicesEn() {
        return this.typeOfServicesEn;
    }

    public List<String> getTypeOfServicesPt() {
        return this.typeOfServicesPt;
    }

    public String getManipulationNotes() {
        return this.manipulationNotes;
    }

    public boolean isManipulation() {
        return this.manipulation;
    }

    public String getContractualBase() {
        return this.contractualBase;
    }
}

