/*
 * Decompiled with CFR 0.152.
 */
package dashboard.shibboleth.mock;

import dashboard.shibboleth.ShibbolethHeader;
import dashboard.shibboleth.mock.MockShibbolethFilter;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class MockShibbolethFilter
extends GenericFilterBean {
    public static final String idp = "http://mock-idp";
    public final String authnContextClass = "urn:oasis:names:tc:SAML:2.0:ac:classes:Password";
    public String role = "admin";

    public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestURI = request.getRequestURI();
        if (requestURI.endsWith("startSSO")) {
            this.role = "admin";
        }
        if ("none".equals(this.role)) {
            chain.doFilter((ServletRequest)request, response);
        } else {
            SetHeader wrapper = new SetHeader(request);
            wrapper.setHeader(ShibbolethHeader.Name_Id.getValue(), this.role);
            wrapper.setHeader(ShibbolethHeader.Shib_Uid.getValue(), this.role);
            wrapper.setHeader(ShibbolethHeader.Shib_Authenticating_Authority.getValue(), idp);
            wrapper.setHeader(ShibbolethHeader.Shib_Email.getValue(), "jane.roe@example.org");
            wrapper.setHeader(ShibbolethHeader.Shib_EduPersonPN.getValue(), "Some eduPersonPrincipalName");
            wrapper.setHeader(ShibbolethHeader.Shib_DisplayName.getValue(), "Jane Roe");
            wrapper.setHeader(ShibbolethHeader.Shib_GivenName.getValue(), "Jane");
            wrapper.setHeader(ShibbolethHeader.Shib_SurName.getValue(), "Roe");
            wrapper.setHeader(ShibbolethHeader.Shib_SchacPersonalUniqueCode.getValue(), "schac_personal_unique_code");
            wrapper.setHeader(ShibbolethHeader.Shib_EduPersonAffiliation.getValue(), "some affiliation");
            wrapper.setHeader(ShibbolethHeader.Shib_EduPersonEntitlement.getValue(), "urn:mace:terena.org:tcs:personal-user;some-filtered-value");
            wrapper.setHeader(ShibbolethHeader.Shib_EduPersonScopedAffiliation.getValue(), "urn:mace:terena.org:tcs:eduPersonScopedAffiliation");
            wrapper.setHeader(ShibbolethHeader.Shib_SURFEckid.getValue(), "some surf eckid value");
            String entityIdHeader = request.getHeader("X-IDP-ENTITY-ID");
            wrapper.setHeader("X-IDP-ENTITY-ID", StringUtils.hasText((String)entityIdHeader) ? entityIdHeader : idp);
            wrapper.setHeader(ShibbolethHeader.Shib_AuthnContext_Class.getValue(), "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
            switch (this.role) {
                case "super": {
                    wrapper.setHeader(ShibbolethHeader.Shib_MemberOf.getValue(), "dashboard.super.user");
                    break;
                }
                case "admin": {
                    wrapper.setHeader(ShibbolethHeader.Shib_MemberOf.getValue(), "dashboard.admin");
                    wrapper.setHeader(ShibbolethHeader.Shib_SURFautorisaties.getValue(), "urn:mace:surfnet.nl:surfnet.nl:sab:role:SURFconextverantwoordelijke;urn:mace:surfnet.nl:surfnet.nl:sab:organizationGUID:ad93daef-0911-e511-80d0-005056956c1a");
                    wrapper.setHeader(ShibbolethHeader.Shib_AuthnContext_Class.getValue(), "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                    break;
                }
                case "viewer": {
                    wrapper.setHeader(ShibbolethHeader.Shib_MemberOf.getValue(), "dashboard.viewer");
                    wrapper.setHeader(ShibbolethHeader.Shib_SURFautorisaties.getValue(), "urn:mace:surfnet.nl:surfnet.nl:sab:organizationGUID:ad93daef-0911-e511-80d0-005056956c1a;urn:mace:surfnet.nl:surfnet.nl:sab:role:SURFconextbeheerder");
                    wrapper.setHeader(ShibbolethHeader.Shib_AuthnContext_Class.getValue(), "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                    break;
                }
            }
            if (requestURI.endsWith("Shibboleth.sso/Login")) {
                String authnContextClassRef = request.getParameter("authnContextClassRef");
                authnContextClassRef = StringUtils.hasText((String)authnContextClassRef) ? authnContextClassRef : "urn:oasis:names:tc:SAML:2.0:ac:classes:Password";
                wrapper.setHeader(ShibbolethHeader.Shib_AuthnContext_Class.getValue(), URLDecoder.decode(authnContextClassRef, Charset.defaultCharset()));
            }
            chain.doFilter((ServletRequest)wrapper, response);
        }
    }
}

