/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import dashboard.domain.CoinUser;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginController {
    public static final String IDP_ID_COOKIE_NAME = "IDP_ID_COOKIE_NAME";
    private final String mailBaseUrl;
    private final Map<Integer, String> loaLevels;
    private final boolean secureCookie;

    public LoginController(@Value(value="${mailBaseUrl}") String mailBaseUrl, @Value(value="${loa_values_supported}") String loaLevels, @Value(value="${server.servlet.session.cookie.secure}") boolean secureCookie) {
        this.mailBaseUrl = mailBaseUrl;
        this.loaLevels = Arrays.stream(loaLevels.replaceAll("\"", "").split(",")).map(String::trim).collect(Collectors.toMap(level -> Integer.valueOf(level.substring(level.length() - 1)), level -> level));
        this.secureCookie = secureCookie;
    }

    @RequestMapping(value={"/startSSO"})
    public void login(HttpServletResponse response, @RequestParam(value="redirect_url") String redirectUrl) throws IOException {
        if (!(redirectUrl = URLDecoder.decode(redirectUrl, Charset.defaultCharset().name())).toLowerCase().startsWith(this.mailBaseUrl.toLowerCase())) {
            throw new IllegalArgumentException("Open redirect attempt");
        }
        response.sendRedirect(redirectUrl);
    }

    @RequestMapping(value={"/login"})
    public void start(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="redirect_url") String redirectUrl, @RequestParam(value="loa", required=false) Integer loa) throws IOException, ServletException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        Optional switchedToIdp = currentUser.getSwitchedToIdp();
        switchedToIdp.ifPresentOrElse(idp -> {
            Cookie cookie = new Cookie(IDP_ID_COOKIE_NAME, idp.getId());
            cookie.setSecure(this.secureCookie);
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
        }, () -> {
            Cookie cookie = new Cookie(IDP_ID_COOKIE_NAME, "");
            cookie.setSecure(this.secureCookie);
            cookie.setMaxAge(0);
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
        });
        SecurityContextHolder.clearContext();
        String target = "/startSSO?redirect_url=" + redirectUrl;
        String shibbolethLogin = String.format("/Shibboleth.sso/Login?target=%s%s", URLEncoder.encode(target, Charset.defaultCharset()), this.convertLoa(loa));
        response.sendRedirect(shibbolethLogin);
    }

    private String convertLoa(Integer loa) {
        if (loa == null) {
            return "";
        }
        String loaLevel = (String)this.loaLevels.get(loa);
        if (!StringUtils.hasText((String)loaLevel)) {
            throw new IllegalArgumentException("Not a valid loa level: " + loa);
        }
        return String.format("&authnContextClassRef=%s", URLEncoder.encode(loaLevel, Charset.defaultCharset()));
    }
}

