/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import dashboard.domain.Action;
import dashboard.domain.JiraFilter;
import dashboard.domain.JiraResponse;
import dashboard.mail.MailBox;
import dashboard.service.impl.JiraClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class JiraClientMock
implements JiraClient {
    private final MailBox mailBox;
    private final ObjectMapper objectMapper;

    public JiraClientMock(MailBox mailBox, ObjectMapper objectMapper) {
        this.mailBox = mailBox;
        this.objectMapper = objectMapper;
    }

    public String create(Action action) {
        String key = String.valueOf(Math.round(Math.random() * 10000.0));
        String subject = String.format("[Services (%s) request] %s connection from IdP '%s' to SP '%s' (Issue : %s)", this.getHost(), action.getType().name(), action.getIdpId(), action.getSpId(), key);
        String body = "A JIRA action / task is created. These are the details:\n";
        String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)action);
        this.mailBox.sendAdministrativeMail(body + json, subject);
        return key;
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }

    public JiraResponse searchTasks(String idp, JiraFilter jiraFilter) {
        return new JiraResponse(Collections.emptyList(), 0, jiraFilter.getStartAt(), jiraFilter.getMaxResults());
    }

    public Map<String, String> validTransitions(String key) {
        return ImmutableMap.of((Object)"To Do", (Object)"1", (Object)"In Progress", (Object)"2", (Object)"Awaiting Input", (Object)"3", (Object)"Resolved", (Object)"4", (Object)"Closed", (Object)"5");
    }

    public void comment(String key, String comment) {
    }

    public void transition(String key, String transitionId, Optional<String> resolution, Optional<String> comment) {
    }

    public void updateOptionalMessage(String jiraKey, String optionalMessage) {
    }
}

