/*
 * Decompiled with CFR 0.152.
 */
package dashboard.util;

import dashboard.domain.LicenseContactPerson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;

public class LicenseContactPersonService
implements ApplicationListener<ContextRefreshedEvent> {
    private final Logger LOG = LoggerFactory.getLogger(LicenseContactPersonService.class);
    private final Resource resource;
    private Map<String, List<LicenseContactPerson>> persons = new HashMap();

    public LicenseContactPersonService(Resource resource) {
        this.resource = resource;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
    }

    private LicenseContactPerson fromColumns(String[] columns) {
        int correction = columns.length > 9 ? 1 : 0;
        String name = this.removeQuotes(correction == 1 ? String.format("%s %s", columns[3], columns[2]) : columns[2]);
        String email = this.removeQuotes(columns[3 + correction]);
        String phone = this.removeQuotes(columns[4 + correction]);
        String idpEntityId = this.removeQuotes(columns[7 + correction]);
        return new LicenseContactPerson(name, email, phone, idpEntityId);
    }

    private String removeQuotes(String s) {
        return s.replaceAll("\"", "").trim();
    }

    public List<LicenseContactPerson> licenseContactPersons(String idpEntityID) {
        return this.persons.getOrDefault(idpEntityID, new ArrayList());
    }

    public List<LicenseContactPerson> getPersons() {
        return this.persons.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private /* synthetic */ LicenseContactPerson lambda$onApplicationEvent$2(String[] columns) {
        return this.fromColumns(columns);
    }

    private static /* synthetic */ boolean lambda$onApplicationEvent$1(String[] columns) {
        return columns.length > 8;
    }

    private static /* synthetic */ String[] lambda$onApplicationEvent$0(String line) {
        return line.split(",");
    }
}

