/*
 * Decompiled with CFR 0.152.
 */
package dashboard.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import dashboard.domain.CoinAuthority;
import dashboard.domain.CoinUser;
import dashboard.domain.IdentityProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpringSecurity {
    public static CoinUser getCurrentUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return new CoinUser();
        }
        Object principal = auth.getPrincipal();
        if (principal != null && principal instanceof CoinUser) {
            return (CoinUser)principal;
        }
        return new CoinUser();
    }

    public static void ensureAccess(IdentityProvider idp) {
        SpringSecurity.validateIdp((IdentityProvider)idp);
    }

    public static void clearSwitchedIdp() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (!currentUser.isSuperUser()) {
            throw new SecurityException("You need to be a super user to clear the selected idp");
        }
        currentUser.removeAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
        currentUser.removeAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
        SpringSecurity.getCurrentUser().setSwitchedToIdp(null);
    }

    public static void setSwitchedToIdp(IdentityProvider idp, String role) {
        SpringSecurity.validateIdp((IdentityProvider)((IdentityProvider)Preconditions.checkNotNull((Object)idp)));
        if (!Strings.isNullOrEmpty((String)role)) {
            CoinUser currentUser = SpringSecurity.getCurrentUser();
            currentUser.removeAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
            currentUser.addAuthority(new CoinAuthority(CoinAuthority.Authority.valueOf((String)role)));
        }
        SpringSecurity.getCurrentUser().setSwitchedToIdp(idp);
    }

    public static IdentityProvider validateIdp(IdentityProvider idp) {
        if (SpringSecurity.getCurrentUser().isSuperUser()) {
            return idp;
        }
        return SpringSecurity.getCurrentUser().getInstitutionIdps().stream().filter(provider -> provider.getId().equals(idp.getId())).findFirst().orElseThrow(() -> new SecurityException(idp.getId() + " is unknown for " + SpringSecurity.getCurrentUser().getUsername()));
    }
}

