/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import dashboard.control.BaseController;
import dashboard.control.RestResponse;
import dashboard.domain.Action;
import dashboard.service.ActionsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard/api/actions"}, produces={"application/json"})
public class ActionsController
extends BaseController {
    @Autowired
    private ActionsService actionsService;

    @RequestMapping(method={RequestMethod.GET})
    public RestResponse<Map<String, Object>> index(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="startAt", required=false, defaultValue="0") int startAt, @RequestParam(value="maxResults", required=false, defaultValue="50") int maxResults) {
        Map result = this.actionsService.getActions(idpEntityId, startAt, maxResults);
        List issues = (List)result.get("issues");
        List enrichedActions = issues.stream().map(arg_0 -> this.cleanAction(arg_0)).collect(Collectors.toList());
        HashMap copyResult = new HashMap(result);
        copyResult.put("issues", enrichedActions);
        return this.createRestResponse(copyResult);
    }

    private Action cleanAction(Action action) {
        return Action.builder().jiraKey((String)action.getJiraKey().orElse(null)).requestDate(action.getRequestDate()).userName(action.getUserName()).type(action.getType()).spName(action.getSpName()).status(action.getStatus()).build();
    }
}

