/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dashboard.control.EnrichJson;
import dashboard.control.GsonHttpMessageConverter;
import dashboard.domain.CoinAuthority;
import dashboard.domain.CoinUser;
import dashboard.domain.Service;
import dashboard.util.AttributeMapFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichJson {
    public static final String FILTERED_USER_ATTRIBUTES = "filteredUserAttributes";
    public static final String SUPER_USER = "superUser";
    public static final String DASHBOARD_ADMIN = "dashboardAdmin";
    private static final Logger LOG = LoggerFactory.getLogger(EnrichJson.class);
    private Map<Class<?>, JsonApplier> mapping = new HashMap();
    private CoinUser currentUser;
    private JsonElement json;

    private EnrichJson(boolean statsEnabled, CoinUser coinUser) {
        LOG.debug("Using {} for user {}", (Object)statsEnabled, (Object)coinUser.getDisplayName());
        this.currentUser = coinUser;
        boolean statsEnabled1 = statsEnabled;
        Gson gson = GsonHttpMessageConverter.GSON_BUILDER.create();
        this.mapping.put(CoinUser.class, (coinUserJsonElement, payload) -> {
            JsonObject user = coinUserJsonElement.getAsJsonObject();
            this.filterDashboardAuthorities(user);
            user.addProperty(SUPER_USER, Boolean.valueOf(((CoinUser)payload).isSuperUser()));
            user.addProperty(DASHBOARD_ADMIN, Boolean.valueOf(((CoinUser)payload).isDashboardAdmin()));
            user.addProperty("statsEnabled", Boolean.valueOf(statsEnabled));
        });
        this.mapping.put(Service.class, (serviceJsonElement, payload) -> {
            Service service = (Service)payload;
            JsonArray filteredUserAttributes = new JsonArray();
            if (service.getArp() != null && !service.getArp().isNoArp() && !service.getArp().isNoAttrArp()) {
                Collection serviceAttributes = AttributeMapFilter.filterAttributes((Map)service.getArp().getAttributes(), (Map)this.currentUser.getAttributeMap());
                serviceAttributes.stream().map(arg_0 -> ((Gson)gson).toJsonTree(arg_0)).forEach(arg_0 -> ((JsonArray)filteredUserAttributes).add(arg_0));
            }
            serviceJsonElement.getAsJsonObject().add(FILTERED_USER_ATTRIBUTES, (JsonElement)filteredUserAttributes);
        });
    }

    public static EnrichJson forUser(boolean statsEnabled, CoinUser currentUser) {
        return new EnrichJson(statsEnabled, currentUser);
    }

    private void filterDashboardAuthorities(JsonObject user) {
        Iterator authorities = user.getAsJsonArray("grantedAuthorities").iterator();
        while (authorities.hasNext()) {
            JsonElement authority = (JsonElement)authorities.next();
            if (!authority.isJsonObject() || CoinAuthority.Authority.valueOf((String)authority.getAsJsonObject().get("authority").getAsString()).isDashboardAuthority()) continue;
            authorities.remove();
        }
    }

    public EnrichJson json(JsonElement json) {
        this.json = json;
        return this;
    }

    public void forPayload(Object payload) {
        Preconditions.checkNotNull((Object)this.json);
        Preconditions.checkNotNull((Object)payload);
        JsonElement payloadAsJsonElement = this.json.getAsJsonObject().get("payload");
        if (payloadAsJsonElement.isJsonObject()) {
            if (this.mapping.containsKey(payload.getClass())) {
                ((JsonApplier)this.mapping.get(payload.getClass())).apply(payloadAsJsonElement, payload);
            }
        } else if (payloadAsJsonElement.isJsonArray()) {
            JsonArray jsonArray = payloadAsJsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Class<?> classOfPayloadElement = ((List)payload).get(i).getClass();
                if (!this.mapping.containsKey(classOfPayloadElement)) continue;
                ((JsonApplier)this.mapping.get(classOfPayloadElement)).apply(jsonArray.get(i), ((List)payload).get(i));
            }
        }
    }
}

