/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.collect.ImmutableList;
import dashboard.control.BaseController;
import dashboard.control.RestResponse;
import dashboard.domain.CoinUser;
import dashboard.domain.Policy;
import dashboard.domain.ServiceProvider;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.pdp.PdpService;
import dashboard.service.EmailService;
import dashboard.util.SpringSecurity;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard/api/policies"})
public class PoliciesController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(PoliciesController.class);
    private static final String ALLOWED_HEADER_VALUE = ImmutableList.of((Object)RequestMethod.GET, (Object)RequestMethod.POST, (Object)RequestMethod.PUT, (Object)RequestMethod.DELETE).stream().map(Enum::name).collect(Collectors.joining(","));
    @Value(value="${dashboard.environment}")
    protected String environment;
    @Autowired
    private PdpService pdpService;
    @Autowired
    private Manage manage;
    @Autowired
    private EmailService emailService;

    @RequestMapping(method={RequestMethod.OPTIONS})
    public ResponseEntity<Void> options(HttpServletResponse response) {
        String allowHeaderValue = this.pdpService.isAvailable() ? ALLOWED_HEADER_VALUE : "";
        response.setHeader("Allow", allowHeaderValue);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET})
    public RestResponse<List<Policy>> listPolicies() {
        return this.createRestResponse((Object)this.pdpService.policies());
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Policy>> createPolicy(@RequestBody Policy policy) {
        return this.whenDashboardAdmin(() -> {
            LOG.debug("Create a policy: {}", (Object)policy);
            ServiceProvider serviceProvider = (ServiceProvider)this.manage.getServiceProvider(policy.getServiceProviderId(), EntityType.saml20_sp, false).get();
            LOG.debug("PolicyEnforcementDecisionRequired:" + serviceProvider.isPolicyEnforcementDecisionRequired());
            if (!serviceProvider.isPolicyEnforcementDecisionRequired()) {
                this.sendNewPolicyWithoutEnforcementDecisionEnabledEmail(policy, SpringSecurity.getCurrentUser());
            }
            return this.createRestResponse((Object)this.pdpService.create(policy));
        });
    }

    @RequestMapping(method={RequestMethod.PUT})
    public ResponseEntity<RestResponse<Policy>> updatePoliciy(@RequestBody Policy policy) {
        return this.whenDashboardAdmin(() -> {
            LOG.debug("Update a policy: {}", (Object)policy);
            return this.createRestResponse((Object)this.pdpService.update(policy));
        });
    }

    @RequestMapping(path={"/new"}, method={RequestMethod.GET})
    public ResponseEntity<RestResponse<Policy>> newPolicy() {
        return this.whenDashboardAdmin(() -> this.createRestResponse((Object)new Policy()));
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public RestResponse<Policy> policy(@PathVariable(value="id") Long id) {
        return this.createRestResponse((Object)this.pdpService.policy(id));
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="id") Long id) {
        this.whenDashboardAdmin(() -> this.createRestResponse((Object)this.pdpService.delete(id)));
    }

    @RequestMapping(path={"/{id}/revisions"}, method={RequestMethod.GET})
    public RestResponse<List<Policy>> revisions(@PathVariable(value="id") Long id) {
        return this.createRestResponse((Object)this.pdpService.revisions(id));
    }

    @RequestMapping(path={"/attributes"}, method={RequestMethod.GET})
    public RestResponse<List<Policy.Attribute>> attributes() {
        return this.createRestResponse((Object)this.pdpService.allowedAttributes());
    }

    private void sendNewPolicyWithoutEnforcementDecisionEnabledEmail(Policy policy, CoinUser user) {
        String subject = String.format("Nieuwe autorisatieregel '%s' voor de omgeving '%s'", policy.getServiceProviderName(), this.environment);
        StringBuilder body = new StringBuilder();
        body.append(String.format("Voor %s is voor het eerst een autorisatieregel (met naam %s) aangemaakt door %s (%s) van %s.\n", StringUtils.hasText((String)policy.getServiceProviderName()) ? policy.getServiceProviderName() : policy.getServiceProviderId(), policy.getName(), user.getDisplayName(), user.getEmail(), user.getInstitutionId()));
        body.append("In Manage staat voor die dienst nog NIET geconfigureerd dat er moet worden gecontroleerd op policies.\n");
        body.append("Als na controle van de regel in de PDP die regel goed lijkt, voeg dan in Manage in het Meta-tabblad de Entry 'coin:policy_enforcement_decision_required' toe aan de dienst, ");
        body.append("push de metadata en informeer de aanmaker van de regel.");
        this.emailService.sendMail("no-reply@surfconext.nl", subject.toString(), body.toString());
    }

    private <T> ResponseEntity<T> whenDashboardAdmin(Supplier<T> supplier) {
        return SpringSecurity.getCurrentUser().isDashboardAdmin() ? ResponseEntity.ok(supplier.get()) : new ResponseEntity(HttpStatus.FORBIDDEN);
    }
}

