/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import com.google.common.base.Preconditions;
import dashboard.domain.Action;
import dashboard.domain.Change;
import dashboard.domain.LicenseStatus;
import dashboard.domain.Settings;
import dashboard.service.impl.JiraTicketSummaryAndDescriptionBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

class JiraTicketSummaryAndDescriptionBuilder {
    JiraTicketSummaryAndDescriptionBuilder() {
    }

    static SummaryAndDescription build(Action action, List<Change> changes) {
        Preconditions.checkNotNull((Object)action);
        StringBuilder description = new StringBuilder();
        StringBuilder summary = new StringBuilder();
        if (action.getType().equals((Object)Action.Type.CHANGE)) {
            description.append("Please update the following settings: \n");
            changes.forEach(change -> description.append(change.toString()).append("\n"));
            description.append("\n");
            Settings settings = action.getSettings();
            if (settings != null) {
                description.append("Additional comments: ").append(settings.getComments()).append("\n");
            }
            description.append("\n");
            summary.append("Change settings for ").append(action.getIdpId());
        } else if (action.getType().equals((Object)Action.Type.QUESTION)) {
            description.append("Question: ").append(action.getBody()).append("\n");
            summary.append("Question about ").append(action.getSpId());
        } else if (Action.Type.LINKREQUEST.equals((Object)action.getType())) {
            description.append("Request: Create a new connection").append("\n");
            summary.append("New connection for IdP ").append(action.getIdpId()).append(" to SP ").append(action.getSpId());
        } else if (Action.Type.UNLINKREQUEST.equals((Object)action.getType())) {
            description.append("Request: terminate a connection").append("\n");
            summary.append("Disconnect IdP ").append(action.getIdpId()).append(" and SP ").append(action.getSpId());
        } else {
            throw new IllegalArgumentException("Don't know how to handle tasks of type " + action.getType());
        }
        description.append("Applicant name: ").append(action.getUserName()).append("\n");
        description.append("Applicant email: ").append(action.getUserEmail()).append("\n");
        description.append("Identity Provider: ").append(action.getIdpId()).append("\n");
        description.append("Service Provider: ").append(action.getSpId()).append("\n");
        if (action.getService() != null && action.getService().getLicenseStatus() != null) {
            description.append("License required: ").append(action.getService().getLicenseStatus().getName()).append("\n");
        }
        if (action.getService() != null && action.getService().isAansluitovereenkomstRefused() && Action.Type.LINKREQUEST.equals((Object)action.getType())) {
            description.append("Customer accepts connecting despite aansluitovereenkomst refused").append("\n");
        }
        description.append("Time: ").append(new SimpleDateFormat("HH:mm dd-MM-yy").format(new Date())).append("\n");
        if (!action.getType().equals((Object)Action.Type.QUESTION)) {
            description.append("Remark from user: ").append(action.getBody()).append("\n");
        }
        return new SummaryAndDescription(summary.toString(), description.toString());
    }

    static String licenseSecured(Action action) {
        LicenseStatus status = action.getService().getLicenseStatus();
        switch (1.$SwitchMap$dashboard$domain$LicenseStatus[status.ordinal()]) {
            case 1: {
                return "Unknown";
            }
            case 2: {
                return "Yes";
            }
            case 3: {
                return "n/a";
            }
        }
        return "Unknown";
    }
}

