/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import dashboard.ShibbolethSecurityConfig;
import dashboard.filter.EnsureAccessToIdpFilter;
import dashboard.manage.Manage;
import dashboard.sab.Sab;
import dashboard.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import dashboard.shibboleth.ShibbolethUserDetailService;
import dashboard.shibboleth.mock.MockShibbolethFilter;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;

@Configuration
@EnableWebSecurity
public class ShibbolethSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethSecurityConfig.class);
    @Autowired
    private Manage manage;
    @Autowired
    private Sab sab;
    @Value(value="${dashboard.admin}")
    private String dashboardAdmin;
    @Value(value="${dashboard.viewer}")
    private String dashboardViewer;
    @Value(value="${dashboard.super.user}")
    private String dashboardSuperUser;
    @Value(value="${admin.surfconext.idp.sabRole}")
    private String adminSufConextIdpRole;
    @Value(value="${viewer.surfconext.idp.sabRole}")
    private String viewerSurfConextIdpRole;
    @Value(value="${dashboard.feature.shibboleth}")
    private boolean shibbolethEnabled;
    @Value(value="${dashboard.feature.consent}")
    private boolean isManageConsentEnabled;

    @Bean
    public FilterRegistrationBean mockShibbolethFilter() {
        FilterRegistrationBean shibFilter = new FilterRegistrationBean();
        if (!this.shibbolethEnabled) {
            shibFilter.setFilter((Filter)new MockShibbolethFilter());
        } else {
            shibFilter.setFilter((Filter)new /* Unavailable Anonymous Inner Class!! */);
        }
        shibFilter.setOrder(Integer.MIN_VALUE);
        return shibFilter;
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/dashboard/api/home", "/dashboard/api/forbidden", "/public/**", "/css/**", "/font/**", "/images/**", "/img/**", "/js/**", "/health", "/info"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.logout().logoutUrl("/dashboard/api/logout").invalidateHttpSession(true).deleteCookies(new String[]{"statsToken"}).logoutSuccessHandler((LogoutSuccessHandler)new DashboardLogoutSuccessHandler(null)).addLogoutHandler((LogoutHandler)new DashboardLogoutHandler(null)).and()).csrf().disable()).addFilterBefore((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean(), this.manage, this.sab, this.dashboardAdmin, this.dashboardViewer, this.dashboardSuperUser, this.adminSufConextIdpRole, this.viewerSurfConextIdpRole, this.isManageConsentEnabled), AbstractPreAuthenticatedProcessingFilter.class).addFilterAfter((Filter)new EnsureAccessToIdpFilter(this.manage), ShibbolethPreAuthenticatedProcessingFilter.class).authorizeRequests().antMatchers(new String[]{"/identity/**"})).hasRole("DASHBOARD_SUPER_USER").antMatchers(new String[]{"/dashboard/api/**"})).hasAnyRole(new String[]{"DASHBOARD_ADMIN", "DASHBOARD_VIEWER", "DASHBOARD_SUPER_USER"}).anyRequest()).authenticated();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        LOG.info("Configuring AuthenticationManager with a PreAuthenticatedAuthenticationProvider");
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }

    @Bean
    protected AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }
}

