/*
 * Decompiled with CFR 0.152.
 */
package dashboard.manage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dashboard.domain.Consent;
import dashboard.domain.ConsentType;
import dashboard.domain.IdentityProvider;
import dashboard.domain.Provider;
import dashboard.domain.ServiceProvider;
import dashboard.manage.EntityType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;

public interface Manage {
    public static final String guestIdp = "https://www.onegini.me";
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public List<ServiceProvider> getAllServiceProviders();

    public Optional<ServiceProvider> getServiceProvider(String var1, EntityType var2, boolean var3);

    public Optional<ServiceProvider> getServiceProviderById(Long var1, EntityType var2);

    public Optional<IdentityProvider> getIdentityProvider(String var1, boolean var2);

    public List<IdentityProvider> getInstituteIdentityProviders(String var1);

    public List<ServiceProvider> getInstitutionalServicesForIdp(String var1);

    public List<IdentityProvider> getAllIdentityProviders();

    public List<IdentityProvider> getLinkedIdentityProviders(String var1);

    public List<ServiceProvider> getLinkedServiceProviders(String var1);

    default public ServiceProvider serviceProvider(Map<String, Object> map, EntityType entityType) {
        ServiceProvider serviceProvider = new ServiceProvider(map);
        serviceProvider.setExampleSingleTenant(entityType.equals((Object)EntityType.single_tenant_template));
        return serviceProvider;
    }

    default public IdentityProvider identityProvider(Map<String, Object> map) {
        return new IdentityProvider(map);
    }

    default public <T extends Provider> Map<String, T> parseProviders(Resource resource, Function<Map<String, Object>, T> provider) throws IOException {
        List providers = (List)objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Map result = providers.stream().map(arg_0 -> this.transformManageMetadata(arg_0)).map(provider).collect(Collectors.toSet()).stream().collect(Collectors.toMap(Provider::getId, Function.identity()));
        return result;
    }

    default public boolean isConnectionAllowed(ServiceProvider sp, IdentityProvider idp) {
        return !(!sp.isAllowedAll() && !sp.getAllowedEntityIds().contains(idp.getId()) || !idp.isAllowedAll() && !idp.getAllowedEntityIds().contains(sp.getId()));
    }

    default public Map<String, Object> transformManageMetadata(Map<String, Object> metadata) {
        Map data = (Map)metadata.get("data");
        HashMap<String, Object> result = new HashMap<String, Object>();
        data.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                result.put(key, (Boolean)Boolean.class.cast(value) != false ? "yes" : "no");
            } else if (value instanceof String) {
                result.put(key, value);
            } else if (value instanceof Number) {
                result.put(key, value);
            }
            switch (key) {
                case "metaDataFields": {
                    Map metaDataFields = (Map)value;
                    result.putAll(metaDataFields);
                    break;
                }
                case "arp": {
                    Map arp = (Map)value;
                    Boolean enabled = (Boolean)arp.get("enabled");
                    if (!enabled.booleanValue()) break;
                    Map attributes = (Map)arp.get("attributes");
                    Map<String, List> attributesMap = attributes.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().map(m -> (String)m.get("value")).collect(Collectors.toList())));
                    Map<String, String> motivationsMap = attributes.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Map)((List)e.getValue()).get(0)).getOrDefault("motivation", "")));
                    result.put("attributes", attributesMap);
                    result.put("motivations", motivationsMap);
                    break;
                }
                case "allowedEntities": {
                    List allowedEntities = (List)value;
                    List allowedEntitiesList = allowedEntities.stream().map(m -> (String)m.get("name")).collect(Collectors.toList());
                    result.put("allowedEntities", allowedEntitiesList);
                    break;
                }
                case "disableConsent": {
                    List disableConsent = (List)value;
                    result.put("disableConsent", disableConsent.stream().map(m -> new Consent((String)m.get("name"), m.containsKey("type") ? ConsentType.valueOf((String)((String)m.get("type")).toUpperCase()) : ConsentType.DEFAULT_CONSENT, (String)m.get("explanation:nl"), (String)m.get("explanation:en"))).collect(Collectors.toList()));
                    break;
                }
            }
        });
        return result;
    }
}

