/*
 * Decompiled with CFR 0.152.
 */
package dashboard.sab;

import dashboard.sab.SabRole;
import java.util.List;

public class SabPerson {
    private final String firstName;
    private final String surname;
    private final String uid;
    private final List<SabRole> roles;

    public SabPerson(String firstName, String surname, String uid, List<SabRole> roles) {
        this.firstName = firstName;
        this.surname = surname;
        this.uid = uid;
        this.roles = roles;
    }

    public String fullname() {
        return String.format("%s %s", this.firstName, this.surname);
    }

    public boolean hasRole(String roleName) {
        return this.roles.stream().anyMatch(role -> roleName.equals(role.roleName));
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getUid() {
        return this.uid;
    }

    public List<SabRole> getRoles() {
        return this.roles;
    }
}

