/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import dashboard.domain.Action;
import dashboard.domain.Change;
import dashboard.service.impl.JiraClient;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClientMock
implements JiraClient {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClientMock.class);
    private Map<String, Action> repository = new LinkedHashMap();
    private AtomicInteger counter = new AtomicInteger(0);

    public String create(Action action, List<Change> changes) {
        String key = this.generateKey();
        this.repository.put(key, action.unbuild().jiraKey(key).body(action.getBody() == null ? "" : action.getBody()).build());
        LOG.debug("Added task (key '{}') to repository: {}", (Object)key, (Object)action);
        return key;
    }

    private String generateKey() {
        return "TASK-" + this.counter.incrementAndGet();
    }

    public Map<String, Object> getTasks(String idp, int startAt, int maxResults) {
        List actions = this.repository.values().stream().filter(action -> action.getIdpId().equals(idp)).collect(Collectors.toList());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("issues", actions);
        result.put("total", actions.size());
        result.put("startAt", startAt);
        result.put("maxResults", maxResults);
        return result;
    }
}

