/*
 * Decompiled with CFR 0.152.
 */
package dashboard.sab;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import dashboard.sab.Sab;
import dashboard.sab.SabPerson;
import dashboard.sab.SabResponseParser;
import dashboard.sab.SabRole;
import dashboard.sab.SabRoleHolder;
import dashboard.sab.SabTransport;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabClient
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClient.class);
    private static final String REQUEST_TEMPLATE_LOCATION = "/sab-request.xml";
    protected static final DateTimeFormatter XML_DATE_TIME_FORMAT = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SabTransport sabTransport;
    private final SabResponseParser sabResponseParser = new SabResponseParser();

    public SabClient(SabTransport sabTransport) {
        this.sabTransport = sabTransport;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<SabRoleHolder> getRoles(String userId) {
        String messageId = UUID.randomUUID().toString();
        String requestBody = this.createRequest(userId, messageId);
        try (InputStream is = this.sabTransport.getResponse(requestBody);){
            Optional<SabRoleHolder> optional = Optional.of(this.sabResponseParser.parse(is));
            return optional;
        }
        catch (IOException e) {
            LOG.warn("Skipping SAB entitlement, SAB request got IOException: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<SabPerson> getPersonsInRoleForOrganization(String organisationAbbreviation, String role) {
        try (InputStream inputStream = this.sabTransport.getRestResponse(organisationAbbreviation, role);){
            List profiles = (List)((HashMap)this.objectMapper.readValue(inputStream, HashMap.class)).get("profiles");
            Collection collection = profiles.stream().map(profile -> {
                List sabRoles = ((List)profile.get("authorisations")).stream().map(authorisation -> new SabRole((String)authorisation.get("short"), (String)authorisation.get("role"))).collect(Collectors.toList());
                return new SabPerson((String)profile.get("firstname"), (String)profile.get("surname"), (String)profile.get("uid"), (String)profile.get("email"), sabRoles);
            }).filter(p -> p.hasRole(role)).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            LOG.warn("Could not retrieve SAB info", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createRequest(String userId, String messageId) {
        try (InputStream is = this.getClass().getResourceAsStream(REQUEST_TEMPLATE_LOCATION);){
            String template = IOUtils.toString((InputStream)is, (String)"UTF-8");
            String issueInstant = XML_DATE_TIME_FORMAT.print(new Date().getTime());
            String string = MessageFormat.format(template, messageId, issueInstant, userId);
            return string;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

