/*
 * Decompiled with CFR 0.152.
 */
package dashboard.shibboleth;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import dashboard.domain.CoinAuthority;
import dashboard.domain.CoinUser;
import dashboard.domain.IdentityProvider;
import dashboard.manage.Manage;
import dashboard.sab.Sab;
import dashboard.sab.SabRoleHolder;
import dashboard.shibboleth.ShibbolethHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final Map<String, ShibbolethHeader> shibHeaders;
    private static final Splitter shibHeaderValueSplitter;
    private static final Logger LOG;
    private Manage manage;
    private Sab sab;
    private String dashboardAdmin;
    private String dashboardViewer;
    private String dashboardSuperUser;
    private String adminSurfConextIdpRole;
    private String viewerSurfConextIdpRole;
    private boolean isManageConsentEnabled;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, Manage manage, Sab sab, String dashboardAdmin, String dashboardViewer, String dashboardSuperUser, String adminSufConextIdpRole, String viewerSurfConextIdpRole, boolean isManageConsentEnabled) {
        this.setAuthenticationManager(authenticationManager);
        this.manage = manage;
        this.sab = sab;
        this.dashboardAdmin = dashboardAdmin;
        this.dashboardSuperUser = dashboardSuperUser;
        this.dashboardViewer = dashboardViewer;
        this.adminSurfConextIdpRole = adminSufConextIdpRole;
        this.viewerSurfConextIdpRole = viewerSurfConextIdpRole;
        this.isManageConsentEnabled = isManageConsentEnabled;
    }

    ShibbolethPreAuthenticatedProcessingFilter() {
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null && LOG.isDebugEnabled()) {
            ArrayList list = Collections.list(headerNames);
            LOG.debug("Received headers {}", list.stream().collect(Collectors.toMap(name -> name, name -> {
                Enumeration headers = request.getHeaders(name);
                return headers != null ? Collections.list(headers) : Collections.emptyList();
            })));
        }
        String uid = (String)this.getFirstShibHeaderValue(ShibbolethHeader.Name_Id, request).orElseThrow(() -> new IllegalArgumentException(String.format("Missing %s Shibboleth header (%s)", ShibbolethHeader.Name_Id.getValue(), request.getRequestURL())));
        String idpId = (String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_Authenticating_Authority, request).orElseThrow(() -> new IllegalArgumentException(String.format("Missing %s Shibboleth header (%s)", ShibbolethHeader.Shib_Authenticating_Authority.getValue(), request.getRequestURL())));
        CoinUser coinUser = new CoinUser();
        coinUser.setUid(uid);
        coinUser.setDisplayName((String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_DisplayName, request).orElse(null));
        coinUser.setEmail((String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_Email, request).orElse(null));
        coinUser.setSchacHomeOrganization((String)this.getFirstShibHeaderValue(ShibbolethHeader.Shib_HomeOrg, request).orElse(null));
        coinUser.setManageConsentEnabled(this.isManageConsentEnabled);
        Map<ShibbolethHeader, List> attributes = shibHeaders.values().stream().filter(h -> StringUtils.hasText((String)request.getHeader(h.getValue()))).collect(Collectors.toMap(h -> h, h -> this.getShibHeaderValues(h, request)));
        coinUser.setAttributeMap(attributes);
        List groups = this.getShibHeaderValues(ShibbolethHeader.Shib_MemberOf, request);
        this.addDashboardRoleForMemberships(coinUser, groups);
        List institutionIdentityProviders = this.getInstitutionIdentityProviders(idpId);
        Preconditions.checkState((!CollectionUtils.isEmpty((Collection)institutionIdentityProviders) ? 1 : 0) != 0, (Object)("no InstitutionIdentityProviders found for '" + idpId + "'"));
        if (institutionIdentityProviders.size() == 1) {
            IdentityProvider idp2 = (IdentityProvider)institutionIdentityProviders.get(0);
            coinUser.setIdp(idp2);
            coinUser.addInstitutionIdp(idp2);
        } else {
            coinUser.setIdp(this.getCurrentIdp(idpId, institutionIdentityProviders));
            coinUser.getInstitutionIdps().addAll(institutionIdentityProviders);
            Collections.sort(coinUser.getInstitutionIdps(), (lh, rh) -> lh.getName().compareTo(rh.getName()));
        }
        Optional roles = this.sab.getRoles(uid);
        LOG.debug("SAB: received roles {} and organization {}", roles.isPresent() ? ((SabRoleHolder)roles.get()).getRoles() : "None", (Object)(roles.isPresent() ? ((SabRoleHolder)roles.get()).getOrganisation() : "None"));
        List institutionIds = institutionIdentityProviders.stream().filter(provider -> StringUtils.hasText((String)provider.getInstitutionId())).map(provider -> provider.getInstitutionId().toUpperCase()).collect(Collectors.toList());
        LOG.debug("Manage: received institution ID's {} ", institutionIds);
        this.addDashboardRoleForEntitlements(coinUser, roles, institutionIds);
        institutionIdentityProviders.stream().filter(idp -> StringUtils.hasText((String)idp.getInstitutionId())).findFirst().ifPresent(idp -> coinUser.setInstitutionId(idp.getInstitutionId()));
        return coinUser;
    }

    private void addDashboardRoleForMemberships(CoinUser user, List<String> groups) {
        if (groups.contains(this.dashboardSuperUser)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_SUPER_USER));
        } else if (groups.contains(this.dashboardAdmin)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
        } else if (groups.contains(this.dashboardViewer)) {
            user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
        }
    }

    private void addDashboardRoleForEntitlements(CoinUser user, Optional<SabRoleHolder> roles, List<String> institutionIds) {
        roles.ifPresent(sabRoleHolder -> {
            boolean institutionIdMatch;
            List entitlements = sabRoleHolder.getRoles();
            String organisation = StringUtils.hasText((String)sabRoleHolder.getOrganisation()) ? sabRoleHolder.getOrganisation().toUpperCase() : null;
            boolean bl = institutionIdMatch = StringUtils.hasText((String)sabRoleHolder.getOrganisation()) && institutionIds.contains(organisation);
            if (institutionIdMatch) {
                if (entitlements.stream().anyMatch(entitlement -> entitlement.indexOf(this.adminSurfConextIdpRole) > -1)) {
                    user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN));
                } else if (entitlements.stream().anyMatch(entitlement -> entitlement.indexOf(this.viewerSurfConextIdpRole) > -1)) {
                    user.addAuthority(new CoinAuthority(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER));
                }
            } else {
                LOG.info("SAB: received entitlements, but the institutionIds from Manage {} do not match the organization name from SAB {}", (Object)institutionIds, (Object)organisation);
            }
        });
    }

    private List<IdentityProvider> getInstitutionIdentityProviders(String idpId) {
        Optional optionalIdentityProvider = this.manage.getIdentityProvider(idpId, false);
        return optionalIdentityProvider.map(idp -> {
            String institutionId = idp.getInstitutionId();
            return StringUtils.hasText((String)institutionId) ? this.manage.getInstituteIdentityProviders(institutionId) : Collections.singletonList(idp);
        }).orElse(Collections.emptyList());
    }

    private Optional<String> getFirstShibHeaderValue(ShibbolethHeader headerName, HttpServletRequest request) {
        return this.getShibHeaderValues(headerName, request).stream().findFirst();
    }

    private List<String> getShibHeaderValues(ShibbolethHeader headerName, HttpServletRequest request) {
        String headerValue = request.getHeader(headerName.getValue());
        return headerValue == null ? Collections.emptyList() : shibHeaderValueSplitter.splitToList((CharSequence)headerValue);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private IdentityProvider getCurrentIdp(String idpId, List<IdentityProvider> institutionIdentityProviders) {
        return institutionIdentityProviders.stream().filter(provider -> provider.getId().equals(idpId)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The Idp('%s') is not present in the list of Idp's returned by the CsaClient", idpId)));
    }

    public void setDashboardAdmin(String dashboardAdmin) {
        this.dashboardAdmin = dashboardAdmin;
    }

    public void setDashboardViewer(String dashboardViewer) {
        this.dashboardViewer = dashboardViewer;
    }

    public void setDashboardSuperUser(String dashboardSuperUser) {
        this.dashboardSuperUser = dashboardSuperUser;
    }

    public void setAdminSurfConextIdpRole(String adminSurfConextIdpRole) {
        this.adminSurfConextIdpRole = adminSurfConextIdpRole;
    }

    public void setViewerSurfConextIdpRole(String viewerSurfConextIdpRole) {
        this.viewerSurfConextIdpRole = viewerSurfConextIdpRole;
    }

    public void setManageConsentEnabled(boolean manageConsentEnabled) {
        this.isManageConsentEnabled = manageConsentEnabled;
    }

    static {
        shibHeaderValueSplitter = Splitter.on((char)';').omitEmptyStrings();
        LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
        shibHeaders = ImmutableMap.builder().put((Object)"urn:mace:dir:attribute-def:uid", (Object)ShibbolethHeader.Shib_Uid).put((Object)"urn:mace:dir:attribute-def:sn", (Object)ShibbolethHeader.Shib_SurName).put((Object)"urn:mace:dir:attribute-def:givenName", (Object)ShibbolethHeader.Shib_GivenName).put((Object)"urn:mace:dir:attribute-def:cn", (Object)ShibbolethHeader.Shib_CommonName).put((Object)"urn:mace:dir:attribute-def:displayName", (Object)ShibbolethHeader.Shib_DisplayName).put((Object)"urn:mace:dir:attribute-def:mail", (Object)ShibbolethHeader.Shib_Email).put((Object)"urn:mace:dir:attribute-def:eduPersonAffiliation", (Object)ShibbolethHeader.Shib_EduPersonAffiliation).put((Object)"urn:mace:dir:attribute-def:eduPersonScopedAffiliation", (Object)ShibbolethHeader.Shib_EduPersonScopedAffiliation).put((Object)"urn:mace:dir:attribute-def:eduPersonEntitlement", (Object)ShibbolethHeader.Shib_EduPersonEntitlement).put((Object)"urn:mace:dir:attribute-def:isMemberOf", (Object)ShibbolethHeader.Shib_MemberOf).put((Object)"urn:mace:dir:attribute-def:eduPersonPrincipalName", (Object)ShibbolethHeader.Shib_EduPersonPN).put((Object)"urn:mace:dir:attribute-def:preferredLanguage", (Object)ShibbolethHeader.Shib_PreferredLanguage).put((Object)"urn:mace:terena.org:attribute-def:schacHomeOrganization", (Object)ShibbolethHeader.Shib_HomeOrg).put((Object)"urn:mace:terena.org:attribute-def:schacHomeOrganizationType", (Object)ShibbolethHeader.Shib_SchacHomeOrganizationType).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlEduPersonHomeOrganization", (Object)ShibbolethHeader.Shib_NlEduPersonHomeOrganization).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlEduPersonStudyBranch", (Object)ShibbolethHeader.Shib_NlEduPersonStudyBranch).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlStudielinkNummer", (Object)ShibbolethHeader.Shib_NlStudielinkNummer).put((Object)"urn:mace:surffederatie.nl:attribute-def:nlDigitalAuthorIdentifier", (Object)ShibbolethHeader.Shib_NlDigitalAuthorIdentifier).put((Object)"urn:mace:surffederatie_nl:attribute-def:nlEduPersonOrgUnit", (Object)ShibbolethHeader.Shib_NlEduPersonOrgUnit).put((Object)"urn:schac:attribute-def:schacPersonalUniqueCode", (Object)ShibbolethHeader.Shib_SchacPersonalUniqueCode).put((Object)"urn:oid:1.3.6.1.4.1.1076.20.100.10.10.1", (Object)ShibbolethHeader.Shib_UserStatus).put((Object)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (Object)ShibbolethHeader.Shib_Accountstatus).put((Object)"urn:oid:1.3.6.1.4.1.1076.20.100.10.10.2", (Object)ShibbolethHeader.Shib_VoName).build();
    }
}

