/*
 * Decompiled with CFR 0.152.
 */
package dashboard.mail;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import dashboard.domain.Action;
import dashboard.domain.InviteRequest;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailBox {
    private JavaMailSender mailSender;
    private String emailFrom;
    private List<String> administrativeEmails;
    private String mailBaseUrl;
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory();

    public MailBox(JavaMailSender mailSender, String emailFrom, String administrativeEmails, String mailBaseUrl) {
        this.administrativeEmails = Arrays.asList(administrativeEmails.split(","));
        this.emailFrom = emailFrom;
        this.mailSender = mailSender;
        this.mailBaseUrl = mailBaseUrl;
    }

    public void sendInviteMail(InviteRequest inviteRequest, Action action) throws MessagingException, IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("title", "Uitnodiging voor een nieuwe SURFconext koppeling");
        variables.put("inviteRequest", (String)inviteRequest);
        variables.put("action", (String)action);
        variables.put("mailBaseUrl", this.mailBaseUrl);
        List<String> emails = inviteRequest.getContactPersons().stream().map(cp -> cp.getEmailAddress()).collect(Collectors.toList());
        String html = this.mailTemplate("invite_request_nl.html", variables);
        emails.forEach(email -> {
            try {
                this.sendMail(html, "Uitnodiging voor een nieuwe SURFconext koppeling", Collections.singletonList(email), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void sendAdministrativeMail(String body, String subject) throws MessagingException, IOException {
        this.sendMail(body, subject, this.administrativeEmails, false);
    }

    private void sendMail(String html, String subject, List<String> to, boolean inHtml) throws MessagingException, IOException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, false);
        helper.setSubject(subject);
        helper.setTo(to.toArray(new String[0]));
        this.setText(html, helper, inHtml);
        helper.setFrom(this.emailFrom);
        this.doSendMail(message);
    }

    protected void setText(String html, MimeMessageHelper helper, boolean isHtml) throws MessagingException, IOException {
        helper.setText(html, isHtml);
    }

    protected void doSendMail(MimeMessage message) {
        new Thread(() -> this.mailSender.send(message)).start();
    }

    private String mailTemplate(String templateName, Map<String, Object> context) throws IOException {
        return this.mustacheFactory.compile("mail_templates/" + templateName).execute((Writer)new StringWriter(), context).toString();
    }
}

