/*
 * Decompiled with CFR 0.152.
 */
package dashboard.filter;

import dashboard.domain.IdentityProvider;
import dashboard.manage.Manage;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.filter.GenericFilterBean;

public class EnsureAccessToIdpFilter
extends GenericFilterBean {
    private Manage manage;

    public EnsureAccessToIdpFilter(Manage manage) {
        this.manage = manage;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.shouldAccessToIdpBeChecked(req)) {
            String idpEntityId = Optional.ofNullable(req.getHeader("X-IDP-ENTITY-ID")).orElse(request.getParameter("idpEntityId"));
            IdentityProvider idp = (IdentityProvider)this.manage.getIdentityProvider(idpEntityId, false).orElseThrow(() -> new SecurityException(idpEntityId + " does not exist"));
            SpringSecurity.ensureAccess((IdentityProvider)idp);
        }
        chain.doFilter(request, response);
    }

    private boolean shouldAccessToIdpBeChecked(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        return requestURI.startsWith("/dashboard/api") && !requestURI.contains("/users/me") && !requestURI.contains("/jsError");
    }
}

