/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import dashboard.domain.Action;
import dashboard.domain.Change;
import dashboard.domain.JiraFilter;
import dashboard.domain.JiraResponse;
import dashboard.domain.Provider;
import dashboard.mail.MailBox;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.service.ActionsService;
import dashboard.service.impl.JiraClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ActionsServiceImpl
implements ActionsService {
    private static final Pattern namePattern = Pattern.compile("^Applicant name: (.*)$", 8);
    private static final Pattern emailPattern = Pattern.compile("^Applicant email: (.*)$", 8);
    @Autowired
    private JiraClient jiraClient;
    @Autowired
    private Manage manage;
    @Autowired
    private MailBox mailBox;
    @Value(value="${administration.email.enabled}")
    private boolean sendAdministrationEmail;

    public JiraResponse searchTasks(String idp, JiraFilter jiraFilter) {
        JiraResponse jiraResponse = this.jiraClient.searchTasks(idp, jiraFilter);
        List issues = jiraResponse.getIssues();
        Map serviceProviders = issues.stream().map(Action::getSpId).filter(StringUtils::hasText).collect(Collectors.toSet()).stream().map(spId -> this.manage.getServiceProvider(spId, EntityType.saml20_sp, true)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Provider::getId, Function.identity()));
        Map identityProviders = issues.stream().map(Action::getIdpId).filter(StringUtils::hasText).collect(Collectors.toSet()).stream().map(idpId -> this.manage.getIdentityProvider(idpId, true)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Provider::getId, Function.identity()));
        List enrichedActions = issues.stream().map(arg_0 -> this.addUser(arg_0)).map(action -> action.unbuild().spName(this.providerName((Provider)serviceProviders.get(action.getSpId()))).spEid(this.providerEid((Provider)serviceProviders.get(action.getSpId()))).idpName(this.providerName((Provider)identityProviders.get(action.getIdpId()))).build()).collect(Collectors.toList());
        jiraResponse.setIssues(enrichedActions);
        return jiraResponse;
    }

    private String providerName(Provider provider) {
        return provider == null ? "Information unavailable" : provider.getName();
    }

    private Long providerEid(Provider provider) {
        return provider == null ? null : provider.getEid();
    }

    private Action addNames(Action action) {
        Optional serviceProvider = this.manage.getServiceProvider(action.getSpId(), EntityType.saml20_sp, true);
        Optional identityProvider = this.manage.getIdentityProvider(action.getIdpId(), true);
        return action.unbuild().idpName(identityProvider.map(Provider::getName).orElse("Information unavailable")).spName(serviceProvider.map(Provider::getName).orElse("Information unavailable")).build();
    }

    private Action addUser(Action action) {
        String body = action.getBody();
        Optional userEmail = this.findUserEmail(body);
        Optional userName = this.findUserName(body);
        return action.unbuild().userEmail(userEmail.orElse("unknown")).userName(userName.orElse("unknown")).build();
    }

    private Optional<String> findUserEmail(String body) {
        return this.matchingGroup(emailPattern, body);
    }

    private Optional<String> findUserName(String body) {
        return this.matchingGroup(namePattern, body);
    }

    private Optional<String> matchingGroup(Pattern pattern, String input) {
        if (StringUtils.isEmpty((Object)input)) {
            return Optional.empty();
        }
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return Optional.ofNullable(matcher.group(1));
        }
        return Optional.empty();
    }

    public Action create(Action action, List<Change> changes) {
        String jiraKey = this.jiraClient.create(action, changes);
        Action savedAction = this.addNames(action).unbuild().jiraKey(jiraKey).build();
        this.sendAdministrationEmail(savedAction);
        if (action.getType().equals((Object)Action.Type.LINKINVITE)) {
            String transitionId = (String)this.jiraClient.validTransitions(jiraKey).get("Start Progress");
            this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.empty());
            transitionId = (String)this.jiraClient.validTransitions(jiraKey).get("Input Needed");
            this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.of("Waiting for approval of SCV."));
        }
        return savedAction;
    }

    public void rejectInviteRequest(String jiraKey, String comment) {
        String transitionId = (String)this.jiraClient.validTransitions(jiraKey).get("To Resolved");
        this.jiraClient.transition(jiraKey, transitionId, Optional.of("Cancelled"), Optional.ofNullable(comment));
        transitionId = (String)this.jiraClient.validTransitions(jiraKey).get("To Closed");
        this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.empty());
    }

    public void approveInviteRequest(String jiraKey, String comment) {
        String transitionId = (String)this.jiraClient.validTransitions(jiraKey).get("Answer (Automatically)");
        this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.ofNullable(comment));
    }

    private void sendAdministrationEmail(Action action) {
        if (!this.sendAdministrationEmail) {
            return;
        }
        String subject = String.format("[Services (%s) request] %s connection from IdP '%s' to SP '%s' (Issue : %s)", this.getHost(), action.getType().name(), action.getIdpId(), action.getSpId(), action.getJiraKey().orElse("???"));
        try {
            this.mailBox.sendAdministrativeMail(action.toString(), subject);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }
}

