/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import dashboard.domain.Action;
import dashboard.domain.Change;
import dashboard.domain.JiraFilter;
import dashboard.domain.JiraResponse;
import dashboard.service.impl.JiraClient;
import dashboard.service.impl.JiraTicketSummaryAndDescriptionBuilder;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class JiraClientImpl
implements JiraClient {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClientImpl.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private String baseUrl;
    private RestTemplate restTemplate;
    private String projectKey;
    private HttpHeaders defaultHeaders;
    private Map<String, Map<String, Map<String, String>>> mappings;
    private ObjectMapper objectMapper = new ObjectMapper();
    private String environment;
    private ArrayList standardFields;

    public JiraClientImpl(String baseUrl, String username, String password, String projectKey) throws IOException {
        this.projectKey = projectKey;
        this.baseUrl = baseUrl;
        this.defaultHeaders = new HttpHeaders();
        this.defaultHeaders.setContentType(MediaType.APPLICATION_JSON);
        byte[] encoded = Base64.encode((byte[])(username + ":" + password).getBytes());
        this.defaultHeaders.add("Authorization", "Basic " + new String(encoded));
        this.restTemplate = new RestTemplate();
        this.environment = baseUrl.contains("test") ? "test" : "prod";
        this.mappings = (Map)this.objectMapper.readValue(new ClassPathResource("jira/mappings.json").getInputStream(), Map.class);
        this.standardFields = new ArrayList<String>(Arrays.asList("summary", "resolution", "status", "assignee", "issuetype", "created", "description", "updated"));
        this.standardFields.addAll(((Map)((Map)this.mappings.get(this.environment)).get("customFields")).values().stream().map(s -> "customfield_" + s).collect(Collectors.toList()));
    }

    public String create(Action action, List<Change> changes) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("priority", ImmutableMap.of((Object)"id", (Object)"3"));
        fields.put("project", ImmutableMap.of((Object)"key", (Object)this.projectKey));
        fields.put("customfield_" + this.spCustomField(), action.getSpId());
        fields.put("customfield_" + this.idpCustomField(), action.getIdpId());
        fields.put("issuetype", ImmutableMap.of((Object)"id", (Object)this.actionToIssueIdentifier(action.getType())));
        JiraTicketSummaryAndDescriptionBuilder.SummaryAndDescription summaryAndDescription = JiraTicketSummaryAndDescriptionBuilder.build((Action)action, changes);
        fields.put("summary", summaryAndDescription.summary);
        fields.put("description", summaryAndDescription.description);
        HashMap<String, HashMap<String, Object>> issue = new HashMap<String, HashMap<String, Object>>();
        issue.put("fields", fields);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending JSON {} to JIRA", (Object)this.objectMapper.writeValueAsString(issue));
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        HttpEntity entity = new HttpEntity(issue, (MultiValueMap)this.defaultHeaders);
        try {
            Map result = (Map)this.restTemplate.postForObject(this.baseUrl + "/issue", (Object)entity, Map.class, new Object[0]);
            return (String)result.get("key");
        }
        catch (HttpClientErrorException e) {
            LOG.error("Failed to create Jira issue: {} ({}) with response:\n{}", new Object[]{e.getStatusCode(), e.getStatusText(), e.getResponseBodyAsString()});
            throw Throwables.propagate((Throwable)e);
        }
    }

    public JiraResponse searchTasks(String idp, JiraFilter jiraFilter) {
        String query = this.buildQueryForIdp(idp, jiraFilter);
        try {
            ImmutableMap body = ImmutableMap.of((Object)"jql", (Object)query, (Object)"maxResults", (Object)jiraFilter.getMaxResults(), (Object)"startAt", (Object)jiraFilter.getStartAt(), (Object)"fields", (Object)this.standardFields);
            HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.defaultHeaders);
            String url = this.baseUrl + "/search";
            Map result = (Map)this.restTemplate.postForObject(url, (Object)entity, Map.class, new Object[0]);
            List issues = ((List)result.get("issues")).stream().map(issue -> {
                Map fields = (Map)issue.get("fields");
                String issueType = (String)((Map)fields.get("issuetype")).get("id");
                Map resolution = (Map)fields.get("resolution");
                return Action.builder().jiraKey((String)issue.get("key")).idpId(Optional.ofNullable((String)fields.get("customfield_" + this.idpCustomField())).orElse("")).spId(Optional.ofNullable((String)fields.get("customfield_" + this.spCustomField())).orElse("")).status((String)((Map)fields.get("status")).get("name")).resolution(resolution != null ? (String)resolution.get("name") : null).type(this.findType(issueType)).requestDate(ZonedDateTime.parse((String)fields.get("created"), DATE_FORMATTER)).updateDate(ZonedDateTime.parse((String)fields.get("updated"), DATE_FORMATTER)).body((String)fields.get("description")).build();
            }).collect(Collectors.toList());
            return new JiraResponse(issues, ((Integer)result.get("total")).intValue(), ((Integer)result.get("startAt")).intValue(), ((Integer)result.get("maxResults")).intValue());
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST)) {
                LOG.error("The Jira query \"{}\" was invalid:\n{}", (Object)query, (Object)e.getResponseBodyAsString());
            } else {
                LOG.error("Jira returned a {} ({}) for query {}:\n{}", new Object[]{e.getStatusCode(), e.getStatusText(), query, e.getResponseBodyAsString()});
            }
        }
        catch (RestClientException e) {
            LOG.error("Error communicating with Jira", (Throwable)e);
        }
        return new JiraResponse(new ArrayList(), 0, jiraFilter.getStartAt(), jiraFilter.getMaxResults());
    }

    Action.Type findType(String issueType) {
        return ((Map)((Map)this.mappings.get(this.environment)).get("issueTypes")).entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(issueType)).map(entry -> Action.Type.valueOf((String)((String)entry.getKey()).toUpperCase())).findFirst().orElseThrow(() -> new RuntimeException("No issue type for " + issueType));
    }

    String actionToIssueIdentifier(Action.Type actionType) {
        return ((Map)((Map)this.mappings.get(this.environment)).get("issueTypes")).entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(actionType.name().toLowerCase())).map(entry -> (String)entry.getValue()).findFirst().orElseThrow(() -> new RuntimeException("No action type for " + actionType));
    }

    public Map<String, String> validTransitions(String key) {
        String url = this.baseUrl + "/issue/" + key + "/transitions";
        Map body = (Map)this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.defaultHeaders), Map.class, new Object[0]).getBody();
        List transitions = body.getOrDefault("transitions", new ArrayList());
        return transitions.stream().collect(Collectors.toMap(map -> (String)String.class.cast(map.get("name")), map -> (String)String.class.cast(map.get("id"))));
    }

    public void comment(String key, String comment) {
        String commentUrl = this.baseUrl + "/issue/" + key + "/comment";
        HttpEntity commentRequestEntity = new HttpEntity((Object)ImmutableMap.of((Object)"body", (Object)comment), (MultiValueMap)this.defaultHeaders);
        this.restTemplate.exchange(commentUrl, HttpMethod.POST, commentRequestEntity, Map.class, new Object[0]);
    }

    public void transition(String key, String transitionId, Optional<String> resolutionOptional, Optional<String> commentOptional) {
        String url = this.baseUrl + "/issue/" + key + "/transitions";
        HashMap<String, Map<String, String>> body = new HashMap<String, Map<String, String>>();
        body.put("transition", Collections.singletonMap("id", transitionId));
        commentOptional.ifPresent(comment -> body.put("update", Collections.singletonMap("comment", Collections.singletonList(Collections.singletonMap("add", Collections.singletonMap("body", comment))))));
        resolutionOptional.ifPresent(resolution -> body.put("fields", Collections.singletonMap("resolution", Collections.singletonMap("name", resolution))));
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)this.defaultHeaders);
        this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
    }

    String buildQueryForIdp(String idp, JiraFilter jiraFilter) {
        String spEntityId;
        List types;
        String escapedIdpField = idp.indexOf("?") > -1 ? idp.substring(0, idp.indexOf("?")) : idp;
        StringBuilder sb = new StringBuilder(String.format("project = %s AND cf[%s]~\"%s\"", this.projectKey, this.idpCustomField(), escapedIdpField));
        List statuses = jiraFilter.getStatuses();
        if (!CollectionUtils.isEmpty((Collection)statuses)) {
            sb.append(String.format(" AND status in (%s)", statuses.stream().map(status -> "\"" + status + "\"").collect(Collectors.joining(", "))));
        }
        if (!CollectionUtils.isEmpty((Collection)(types = jiraFilter.getTypes()))) {
            String issueTypes = types.stream().map(type -> (String)((Map)((Map)this.mappings.get(this.environment)).get("issueTypes")).get(type.name().toLowerCase())).collect(Collectors.joining(", "));
            sb.append(String.format(" AND issueType in (%s)", issueTypes));
        }
        if (StringUtils.hasText((String)(spEntityId = jiraFilter.getSpEntityId()))) {
            String escapedSpEntityId = spEntityId.indexOf("?") > -1 ? spEntityId.substring(0, spEntityId.indexOf("?")) : spEntityId;
            sb.append(String.format(" AND cf[%s]~\"%s\"", this.spCustomField(), escapedSpEntityId));
        }
        if (StringUtils.hasText((String)jiraFilter.getKey())) {
            sb.append(" AND key = \"" + jiraFilter.getKey() + "\"");
        }
        if (jiraFilter.getFrom() != null) {
            String from = DateTimeFormatter.ofPattern("YYYY-MM-dd").withZone(ZoneId.systemDefault()).format(Instant.ofEpochSecond(jiraFilter.getFrom()));
            sb.append(" AND created >= \"" + from + "\"");
        }
        if (jiraFilter.getTo() != null) {
            String to = DateTimeFormatter.ofPattern("YYYY-MM-dd").withZone(ZoneId.systemDefault()).format(Instant.ofEpochSecond(jiraFilter.getTo()));
            sb.append(" AND created <= \"" + to + "\"");
        }
        if (StringUtils.hasText((String)jiraFilter.getSortBy())) {
            sb.append(" ORDER BY ");
            switch (jiraFilter.getSortBy()) {
                case "requestDate": {
                    sb.append("created ");
                    break;
                }
                case "updateDate": {
                    sb.append("updated ");
                    break;
                }
                case "spName": {
                    sb.append("cf[" + this.spCustomField() + "]");
                    break;
                }
                case "type": {
                    sb.append("issueType");
                    break;
                }
                case "jiraKey": {
                    sb.append("key");
                    break;
                }
                case "status": {
                    sb.append("status");
                }
            }
            sb.append(jiraFilter.isSortAsc() ? " ASC" : " DESC");
        }
        return sb.toString();
    }

    private String idpCustomField() {
        return (String)((Map)((Map)this.mappings.get(this.environment)).get("customFields")).get("idpEntityId");
    }

    private String spCustomField() {
        return (String)((Map)((Map)this.mappings.get(this.environment)).get("customFields")).get("spEntityId");
    }
}

