/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import dashboard.domain.CoinUser;
import dashboard.domain.IdentityProvider;
import dashboard.util.SpringSecurity;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.crypto.codec.Base64;

public interface Constants {
    public static final String HTTP_X_IDP_ENTITY_ID = "X-IDP-ENTITY-ID";

    default public ClientHttpRequestFactory clientHttpRequestFactory(int timeout) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setReadTimeout(timeout);
        requestFactory.setConnectTimeout(timeout);
        requestFactory.setHttpClient((HttpClient)HttpClients.custom().disableCookieManagement().build());
        return requestFactory;
    }

    default public String authorizationHeaderValue(String username, String password) {
        return "Basic " + new String(Base64.encode((byte[])String.format("%s:%s", username, password).getBytes()));
    }

    default public String currentUserIdp() {
        CoinUser user = SpringSecurity.getCurrentUser();
        IdentityProvider idp = user.getSwitchedToIdp().orElse(user.getIdp());
        return idp.getId();
    }
}

