/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import dashboard.control.Constants;
import dashboard.domain.Provider;
import dashboard.domain.ServiceProvider;
import dashboard.manage.Manage;
import dashboard.stats.Stats;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard/api/stats"})
public class StatsController
implements Constants {
    private Manage manage;
    private Stats stats;

    @Autowired
    public StatsController(Stats stats, Manage manage) {
        this.manage = manage;
        this.stats = stats;
    }

    @GetMapping(value={"loginTimeFrame"})
    public List<Object> loginTimeFrame(@RequestParam(value="from") long from, @RequestParam(value="to") long to, @RequestParam(value="scale") String scale, @RequestParam(value="spEntityId", required=false) Optional<String> spEntityId) {
        return this.stats.loginTimeFrame(from, to, scale, spEntityId);
    }

    @GetMapping(value={"loginAggregated"})
    public List<Object> loginAggregated(@RequestParam(value="period") String period, @RequestParam(value="spEntityId", required=false) Optional<String> spEntityId) {
        return this.stats.loginAggregated(period, spEntityId);
    }

    @GetMapping(value={"uniqueLoginCount"})
    public List<Object> uniqueLoginCount(@RequestParam(value="from") long from, @RequestParam(value="to") long to, @RequestParam(value="spEntityId") String spEntityId) {
        return this.stats.uniqueLoginCount(from, to, spEntityId);
    }

    @GetMapping(value={"serviceProviders"})
    public List<Map<String, Object>> serviceProviders(Locale locale) {
        return this.manage.getLinkedServiceProviders(this.currentUserIdp()).stream().map(sp -> this.mapServiceProvider(sp, locale.getLanguage())).collect(Collectors.toList());
    }

    private Map<String, Object> mapServiceProvider(ServiceProvider sp, String language) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("value", sp.getId());
        String nameEN = sp.getName(Provider.Language.EN);
        String nameNL = sp.getName(Provider.Language.NL);
        String name = "en".equals(language) && StringUtils.hasText((String)nameEN) ? nameEN : nameNL;
        result.put("display", StringUtils.hasText((String)name) ? name : sp.getId());
        return result;
    }
}

