/*
 * Decompiled with CFR 0.152.
 */
package dashboard.domain;

import dashboard.domain.Consent;
import dashboard.domain.Provider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class IdentityProvider
extends Provider
implements Serializable {
    private String institutionId;
    private Map<String, String> keywords = new HashMap();
    private List<Consent> disableConsent;
    private boolean connectToRSServicesAutomatically;
    private Map<String, String> organisationNames = new HashMap();
    private Map<String, String> organisationDisplayNames = new HashMap();

    public IdentityProvider() {
    }

    public IdentityProvider(String id, String institutionId, String name, Long eid) {
        this.setId(id);
        this.setEid(eid);
        this.institutionId = institutionId;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.setName(name);
            this.addName("en", name);
            this.addName("nl", name);
        }
    }

    public IdentityProvider(Map<String, Object> metaData) {
        super(metaData);
        this.institutionId = (String)metaData.get("coin:institution_id");
        this.disableConsent = metaData.getOrDefault("disableConsent", new ArrayList());
        this.addKeywords("en", (String)metaData.get("keywords:en"));
        this.addKeywords("nl", (String)metaData.get("keywords:nl"));
        IntStream.range(1, 6).forEach(i -> {
            if ("http://refeds.org/category/research-and-scholarship".equals(metaData.get("coin:entity_categories:" + i))) {
                this.connectToRSServicesAutomatically = true;
            }
        });
        this.organisationNames.put("en", (String)metaData.get("OrganizationName:en"));
        this.organisationNames.put("nl", (String)metaData.get("OrganizationName:nl"));
        this.organisationDisplayNames.put("en", (String)metaData.get("OrganizationDisplayName:en"));
        this.organisationDisplayNames.put("nl", (String)metaData.get("OrganizationDisplayName:nl"));
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public Map<String, String> getKeywords() {
        return this.keywords;
    }

    private void addKeywords(String language, String keywords) {
        if (keywords != null) {
            this.keywords.put(language, keywords);
        }
    }

    public List<Consent> getDisableConsent() {
        return this.disableConsent;
    }

    public boolean isConnectToRSServicesAutomatically() {
        return this.connectToRSServicesAutomatically;
    }

    public Map<String, String> getOrganisationNames() {
        return this.organisationNames;
    }

    public Map<String, String> getOrganisationDisplayNames() {
        return this.organisationDisplayNames;
    }

    public String toString() {
        return "IdentityProvider{id='" + this.getId() + '\'' + ", institutionId='" + this.institutionId + '\'' + '}';
    }
}

