/*
 * Decompiled with CFR 0.152.
 */
package dashboard.pdp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import dashboard.control.Constants;
import dashboard.domain.CoinUser;
import dashboard.domain.IdentityProvider;
import dashboard.domain.Policy;
import dashboard.pdp.PdpService;
import dashboard.pdp.PdpServiceImpl;
import dashboard.pdp.PolicyNameNotUniqueException;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdpServiceImpl
implements PdpService,
Constants {
    private static final Logger LOG = LoggerFactory.getLogger(PdpServiceImpl.class);
    protected static final String X_IDP_ENTITY_ID = "X-IDP-ENTITY-ID";
    protected static final String X_UNSPECIFIED_NAME_ID = "X-UNSPECIFIED-NAME-ID";
    protected static final String X_DISPLAY_NAME = "X-DISPLAY-NAME";
    private final RestTemplate pdpRestTemplate;
    private final String server;
    private final ObjectMapper objectMapper;

    public PdpServiceImpl(String server, String username, String password) {
        Preconditions.checkArgument((boolean)server.startsWith("http"));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0);
        this.pdpRestTemplate = new RestTemplate(this.clientHttpRequestFactory(10000));
        this.pdpRestTemplate.setInterceptors((List)ImmutableList.of((request, body, execution) -> {
            CoinUser user = SpringSecurity.getCurrentUser();
            IdentityProvider idp = user.getSwitchedToIdp().orElse(user.getIdp());
            HttpHeaders headers = request.getHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept((List)ImmutableList.of((Object)MediaType.APPLICATION_JSON));
            headers.set("Authorization", this.authorizationHeaderValue(username, password));
            headers.set("X-IDP-ENTITY-ID", idp.getId());
            headers.set("X-UNSPECIFIED-NAME-ID", user.getUid());
            headers.set("X-DISPLAY-NAME", user.getDisplayName());
            return execution.execute(request, body);
        }));
        this.server = server;
        this.objectMapper = new ObjectMapper();
    }

    public boolean isAvailable() {
        try {
            Set options = this.pdpRestTemplate.optionsForAllow(this.buildUri("/protected/policies"));
            return options.contains(HttpMethod.GET) && !options.contains(HttpMethod.PATCH);
        }
        catch (RestClientException e) {
            LOG.warn("PDP protected api was not available", (Throwable)e);
            return false;
        }
    }

    public List<Policy> policies() {
        RequestEntity request = this.buildGetRequest("/protected/policies");
        return (List)this.executeWithExceptionLogging(() -> (List)this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody());
    }

    public Policy policy(Long id) {
        RequestEntity request = this.buildGetRequest("/protected/policies/" + id);
        return (Policy)this.executeWithExceptionLogging(() -> (Policy)this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody());
    }

    public Policy create(Policy policy) {
        RequestEntity request = this.buildPostRequest("/protected/policies", (Object)policy);
        try {
            try {
                String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)policy);
                LOG.info("creation of policy {}", (Object)json);
            }
            catch (IOException e) {
                LOG.error("oeps", (Throwable)e);
            }
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (Policy)response.getBody();
        }
        catch (HttpStatusCodeException sce) {
            Optional exception;
            if (sce.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST) && (exception = this.extractException(sce.getResponseBodyAsByteArray())).isPresent()) {
                throw (PolicyNameNotUniqueException)exception.get();
            }
            LOG.error("Response error: {} {}:\n {}", new Object[]{sce.getStatusCode(), sce.getStatusText(), sce.getResponseBodyAsString()});
            throw Throwables.propagate((Throwable)sce);
        }
    }

    private Optional<PolicyNameNotUniqueException> extractException(byte[] byteArray) {
        try {
            JsonNode readTree = this.objectMapper.readTree(byteArray);
            return Optional.ofNullable(readTree.findValue("details")).map(details -> {
                Iterable fields = () -> details.fields();
                return StreamSupport.stream(fields.spliterator(), false).map(entry -> ((JsonNode)entry.getValue()).asText()).filter(StringUtils::hasText).collect(Collectors.joining(", "));
            }).map(PolicyNameNotUniqueException::new);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Policy update(Policy policy) {
        RequestEntity request = this.buildPutRequest("/protected/policies", (Object)policy);
        return (Policy)this.executeWithExceptionLogging(() -> {
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (Policy)response.getBody();
        });
    }

    public ResponseEntity<String> delete(Long id) {
        RequestEntity request = this.buildDeleteRequest("/protected/policies/" + id);
        return (ResponseEntity)this.executeWithExceptionLogging(() -> this.pdpRestTemplate.exchange(request, String.class));
    }

    public List<Policy> revisions(Long id) {
        RequestEntity request = this.buildGetRequest("/protected/revisions/" + id);
        return (List)this.executeWithExceptionLogging(() -> {
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (List)response.getBody();
        });
    }

    public List<Policy.Attribute> allowedAttributes() {
        RequestEntity request = this.buildGetRequest("/protected/attributes/");
        return (List)this.executeWithExceptionLogging(() -> {
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return ((List)response.getBody()).stream().map(aa -> new Policy.Attribute(AllowedAttribute.access$000((AllowedAttribute)aa), AllowedAttribute.access$100((AllowedAttribute)aa))).collect(Collectors.toList());
        });
    }

    private <T> T executeWithExceptionLogging(Supplier<T> makeRequest) {
        try {
            return makeRequest.get();
        }
        catch (HttpStatusCodeException sce) {
            LOG.error("Response error: {} {}:\n {}", new Object[]{sce.getStatusCode(), sce.getStatusText(), sce.getResponseBodyAsString()});
            throw Throwables.propagate((Throwable)sce);
        }
    }

    private RequestEntity<?> buildDeleteRequest(String path) {
        return RequestEntity.delete((URI)this.buildUri(path)).build();
    }

    private RequestEntity<?> buildPostRequest(String path, Object body) {
        return RequestEntity.post((URI)this.buildUri(path)).body(body);
    }

    private RequestEntity<?> buildPutRequest(String path, Object body) {
        return RequestEntity.put((URI)this.buildUri(path)).body(body);
    }

    private RequestEntity<?> buildGetRequest(String path) {
        return RequestEntity.get((URI)this.buildUri(path)).build();
    }

    private URI buildUri(String path) {
        Preconditions.checkArgument((boolean)path.startsWith("/"));
        return URI.create(String.format("%s/pdp/api%s", this.server, path));
    }
}

