/*
 * Decompiled with CFR 0.152.
 */
package dashboard.stats;

import com.google.common.collect.ImmutableList;
import dashboard.control.Constants;
import dashboard.manage.Manage;
import dashboard.stats.Stats;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

public class StatsImpl
implements Stats,
Constants {
    private RestTemplate restTemplate = new RestTemplate(this.clientHttpRequestFactory(10000));
    private String baseUrl;
    private Manage manage;

    @Autowired
    public StatsImpl(@Value(value="${statsUser}") String user, @Value(value="${statsPassword}") String password, @Value(value="${statsBaseUrl}") String baseUrl) {
        this.baseUrl = baseUrl;
        this.manage = this.manage;
        this.restTemplate.setInterceptors((List)ImmutableList.of((request, body, execution) -> {
            HttpHeaders headers = request.getHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept((List)ImmutableList.of((Object)MediaType.APPLICATION_JSON));
            headers.set("Authorization", this.authorizationHeaderValue(user, password));
            return execution.execute(request, body);
        }));
    }

    public List<Object> loginTimeFrame(long from, long to, String scale, Optional<String> spEntityIdOptional) {
        StringBuilder url = new StringBuilder(String.format("%s/public/login_time_frame?from=%s&to=%s&include_unique=true&scale=%s&epoch=ms&idp_id=%s", this.baseUrl, from, to, scale, this.currentUserIdp()));
        spEntityIdOptional.ifPresent(spEntityId -> url.append(String.format("&sp_id=%s", spEntityId)));
        return (List)this.restTemplate.getForEntity(url.toString(), List.class, new Object[0]).getBody();
    }

    public List<Object> loginAggregated(String period, Optional<String> spEntityIdOptional) {
        StringBuilder url = new StringBuilder(String.format("%s/public/login_aggregated?period=%s&include_unique=true&idp_id=%s&group_by=sp_id", this.baseUrl, period, this.currentUserIdp()));
        spEntityIdOptional.ifPresent(spEntityId -> url.append(String.format("&sp_id=%s", spEntityId)));
        return (List)this.restTemplate.getForEntity(url.toString(), List.class, new Object[0]).getBody();
    }

    public List<Object> uniqueLoginCount(long from, long to, String spEntityId) {
        String url = String.format("%s/public/unique_login_count?from=%s&to=%s&include_unique=true&epoch=ms&idp_id=%s&sp_id=%s", this.baseUrl, from, to, this.currentUserIdp(), spEntityId);
        return (List)this.restTemplate.getForEntity(url, List.class, new Object[0]).getBody();
    }
}

