/*
 * Decompiled with CFR 0.152.
 */
package dashboard.shibboleth.mock;

import dashboard.shibboleth.ShibbolethHeader;
import dashboard.shibboleth.mock.MockShibbolethFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.filter.GenericFilterBean;

public class MockShibbolethFilter
extends GenericFilterBean {
    public static final String idp = "https://idp.surfnet.nl";
    public static final String role = "admin";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        req.getSession(true).setAttribute("mockUser", (Object)role);
        SetHeader wrapper = new SetHeader(req);
        wrapper.setHeader(ShibbolethHeader.Name_Id.getValue(), role);
        wrapper.setHeader(ShibbolethHeader.Shib_Uid.getValue(), role);
        wrapper.setHeader(ShibbolethHeader.Shib_Authenticating_Authority.getValue(), idp);
        wrapper.setHeader(ShibbolethHeader.Shib_GivenName.getValue(), "Some given name");
        wrapper.setHeader(ShibbolethHeader.Shib_Email.getValue(), "jane.roe@example.org");
        wrapper.setHeader(ShibbolethHeader.Shib_EduPersonPN.getValue(), "Some eduPersonPrincipalName");
        wrapper.setHeader(ShibbolethHeader.Shib_DisplayName.getValue(), "Jane Roe");
        wrapper.setHeader(ShibbolethHeader.Shib_SchacPersonalUniqueCode.getValue(), "schac_personal_unique_code");
        wrapper.setHeader(ShibbolethHeader.Shib_EduPersonEntitlement.getValue(), "urn:mace:terena.org:tcs:personal-user;some-filtered-value");
        wrapper.setHeader(ShibbolethHeader.Shib_EduPersonScopedAffiliation.getValue(), "urn:mace:terena.org:tcs:eduPersonScopedAffiliation");
        wrapper.setHeader("X-IDP-ENTITY-ID", idp);
        switch (role) {
            case "super": {
                wrapper.setHeader(ShibbolethHeader.Shib_MemberOf.getValue(), "dashboard.super.user2");
                break;
            }
            case "admin": {
                wrapper.setHeader(ShibbolethHeader.Shib_MemberOf.getValue(), "dashboard.admin");
                break;
            }
            case "viewer": {
                wrapper.setHeader(ShibbolethHeader.Shib_MemberOf.getValue(), "dashboard.viewer");
                break;
            }
        }
        chain.doFilter((ServletRequest)wrapper, response);
    }
}

