/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import dashboard.control.RestResponse;
import java.util.Locale;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.LocaleResolver;

@Controller
public abstract class BaseController {
    @Resource(name="localeResolver")
    protected LocaleResolver localeResolver;

    @ModelAttribute(value="locale")
    public Locale getLocale(HttpServletRequest request) {
        return this.localeResolver.resolveLocale(request);
    }

    public <T> RestResponse<T> createRestResponse(T payload) {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        return RestResponse.of((Locale)this.getLocale(request), payload);
    }
}

