/*
 * Decompiled with CFR 0.152.
 */
package idensys.control;

import idensys.saml.SAMLBuilder;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.joda.time.DateTime;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyName;
import org.opensaml.xml.signature.SignatureException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IdpMetadataController {
    private String metadata;
    private DateTime validUntil;
    @Autowired
    private KeyManager keyManager;
    @Autowired
    private CachingMetadataManager metadataManager;
    @Value(value="${proxy.base_url}")
    private String idensysBaseUrl;
    @Value(value="${proxy.entity_id}")
    private String entityId;
    @Value(value="${proxy.validity_duration_metadata_ms}")
    private int validityDurationMetadataMilliseconds;
    @Value(value="${proxy.base_url}")
    private String baseUrl;
    @Value(value="${proxy.key_name}")
    private String proxyKeyName;

    @RequestMapping(method={RequestMethod.GET}, value={"/idp/metadata"}, produces={"application/xml"})
    public String metadata() throws SecurityException, ParserConfigurationException, SignatureException, MarshallingException, TransformerException {
        if (this.metadata == null || this.validUntil.isBeforeNow()) {
            this.metadata = this.generateMetadata();
        }
        return this.metadata;
    }

    private String generateMetadata() throws SecurityException, SignatureException, MarshallingException, ParserConfigurationException, TransformerException {
        this.validUntil = new DateTime().plusMillis(this.validityDurationMetadataMilliseconds);
        EntityDescriptor entityDescriptor = SAMLBuilder.buildSAMLObject(EntityDescriptor.class, EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDescriptor.setEntityID(this.entityId);
        entityDescriptor.setID(UUID.randomUUID().toString());
        entityDescriptor.setValidUntil(this.validUntil);
        IDPSSODescriptor idpssoDescriptor = SAMLBuilder.buildSAMLObject(IDPSSODescriptor.class, IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        NameIDFormat nameIDFormat = SAMLBuilder.buildSAMLObject(NameIDFormat.class, NameIDFormat.DEFAULT_ELEMENT_NAME);
        nameIDFormat.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        idpssoDescriptor.getNameIDFormats().add(nameIDFormat);
        idpssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SingleSignOnService singleSignService = SAMLBuilder.buildSAMLObject(SingleSignOnService.class, SingleSignOnService.DEFAULT_ELEMENT_NAME);
        singleSignService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        singleSignService.setLocation(this.baseUrl + "/saml/idp/login");
        idpssoDescriptor.getSingleSignOnServices().add(singleSignService);
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        Credential credential = (Credential)this.keyManager.resolveSingle((Object)new CriteriaSet((Criteria)new EntityIDCriteria(this.entityId)));
        KeyDescriptor encKeyDescriptor = SAMLBuilder.buildSAMLObject(KeyDescriptor.class, KeyDescriptor.DEFAULT_ELEMENT_NAME);
        encKeyDescriptor.setUse(UsageType.SIGNING);
        KeyInfo keyInfo = keyInfoGenerator.generate(credential);
        KeyName keyName = SAMLBuilder.buildSAMLObject(KeyName.class, KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.proxyKeyName);
        keyInfo.getKeyNames().add(keyName);
        encKeyDescriptor.setKeyInfo(keyInfo);
        idpssoDescriptor.getKeyDescriptors().add(encKeyDescriptor);
        entityDescriptor.getRoleDescriptors().add(idpssoDescriptor);
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setIdpDiscoveryEnabled(false);
        extendedMetadata.setSignMetadata(true);
        extendedMetadata.setSigningAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        extendedMetadata.setIdpDiscoveryEnabled(false);
        extendedMetadata.setSigningKey(this.entityId);
        extendedMetadata.setLocal(true);
        return SAMLUtil.getMetadataAsString((MetadataManager)this.metadataManager, (KeyManager)this.keyManager, (EntityDescriptor)entityDescriptor, (ExtendedMetadata)extendedMetadata);
    }
}

