/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import org.opensaml.Configuration;
import org.opensaml.xml.security.BasicSecurityConfiguration;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.security.saml.SAMLBootstrap;

public class CustomSAMLBootstrap
extends SAMLBootstrap {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        super.postProcessBeanFactory(beanFactory);
        BasicSecurityConfiguration config = (BasicSecurityConfiguration)Configuration.getGlobalSecurityConfiguration();
        config.registerSignatureAlgorithmURI("RSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        config.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
    }

    protected void setMetadataKeyInfoGenerator() {
        NamedKeyInfoGeneratorManager manager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager();
        X509KeyInfoGeneratorFactory generator = new X509KeyInfoGeneratorFactory();
        generator.setEmitEntityCertificate(true);
        generator.setEmitEntityCertificateChain(true);
        generator.setEmitSubjectAltNamesAsKeyNames(true);
        generator.setEmitKeyNames(true);
        manager.registerFactory("MetadataKeyInfoGenerator", (KeyInfoGeneratorFactory)generator);
    }
}

