/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import idensys.saml.SAMLAttribute;
import idensys.saml.SAMLBuilder;
import idensys.saml.SAMLPrincipal;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensaml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public class DefaultSAMLUserDetailsService
implements SAMLUserDetailsService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSAMLUserDetailsService.class);

    public Principal loadUserBySAML(SAMLCredential credential) {
        LOG.debug("loadUserBySAML {}", (Object)credential);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !(authentication.getPrincipal() instanceof SAMLPrincipal)) {
            throw new IllegalArgumentException("Authentication.Principal is not SAMLPrincipal, but " + authentication);
        }
        SAMLPrincipal principal = (SAMLPrincipal)authentication.getPrincipal();
        List<SAMLAttribute> attributes = credential.getAttributes().stream().map(attribute -> new SAMLAttribute(attribute.getName(), attribute.getAttributeValues().stream().map(SAMLBuilder::getStringValueFromXMLObject).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()))).collect(Collectors.toList());
        NameID nameID = credential.getNameID();
        principal.elevate(nameID.getValue(), nameID.getFormat(), attributes);
        return principal;
    }
}

