/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import idensys.saml.NoProxySAMLPrincipal;
import idensys.saml.ParameterDecodingHttpServletRequestWrapper;
import idensys.saml.SAMLAuthentication;
import idensys.saml.SAMLAuthenticationException;
import idensys.saml.SAMLMessageHandler;
import idensys.saml.SAMLPrincipal;
import idensys.saml.ServiceProvider;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class IdentityProviderAuthnFilter
extends OncePerRequestFilter
implements AuthenticationEntryPoint {
    private final SAMLMessageHandler samlMessageHandler;
    private final Map<String, ServiceProvider> serviceProviders;
    private final boolean serviceProvidersAllowUnknown;
    private final Environment environment;

    public IdentityProviderAuthnFilter(SAMLMessageHandler samlMessageHandler, Map<String, ServiceProvider> serviceProviders, boolean serviceProvidersAllowUnknown, Environment environment) {
        this.samlMessageHandler = samlMessageHandler;
        this.serviceProviders = serviceProviders;
        this.serviceProvidersAllowUnknown = serviceProvidersAllowUnknown;
        this.environment = environment;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (this.authenticationNotRequired()) {
            this.sendAuthResponse(response);
            return;
        }
        if (!this.isSAML(request)) {
            if (!request.getRequestURI().contains("test")) {
                throw new IllegalArgumentException("No SAMLRequest or SAMLResponse query path parameter, invalid SAML 2 HTTP Redirect message");
            }
            SecurityContextHolder.getContext().setAuthentication((Authentication)new SAMLAuthentication(new NoProxySAMLPrincipal()));
            request.getRequestDispatcher("/saml/login").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Object inputRequest = this.environment.acceptsProfiles(new String[]{"local"}) ? new ParameterDecodingHttpServletRequestWrapper(request) : request;
        SAMLMessageContext messageContext = this.samlMessageHandler.extractSAMLMessageContext((HttpServletRequest)inputRequest);
        AuthnRequest authnRequest = (AuthnRequest)messageContext.getInboundSAMLMessage();
        SAMLPrincipal principal = new SAMLPrincipal(authnRequest.getIssuer().getValue(), authnRequest.getID(), authnRequest.getAssertionConsumerServiceURL(), messageContext.getRelayState());
        this.validateAssertionConsumerService(principal);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new SAMLAuthentication(principal));
        request.getRequestDispatcher("/saml/login").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!SAMLUtil.processFilter((String)"/saml/idp", (HttpServletRequest)request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.commence(request, response, null);
    }

    private void validateAssertionConsumerService(SAMLPrincipal principal) {
        ServiceProvider serviceProvider = this.serviceProviders.get(principal.getServiceProviderEntityID());
        if (serviceProvider == null) {
            if (this.serviceProvidersAllowUnknown) {
                this.logger.warn((Object)("Allowing SP " + principal.getServiceProviderEntityID() + " because configured to allow unknown SPs"));
                return;
            }
            throw new SAMLAuthenticationException("ServiceProvider " + principal.getServiceProviderEntityID() + " is unknown", null, principal);
        }
        if (!serviceProvider.getAssertionConsumerServiceURLs().contains(principal.getAssertionConsumerServiceURL())) {
            throw new SAMLAuthenticationException("ServiceProvider " + principal.getServiceProviderEntityID() + " has not published ACS " + principal.getAssertionConsumerServiceURL() + " in their assertionConsumerURLS: " + serviceProvider.getAssertionConsumerServiceURLs(), null, principal);
        }
    }

    private void sendAuthResponse(HttpServletResponse response) {
        SAMLPrincipal principal = (SAMLPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        this.samlMessageHandler.sendAuthnResponse(principal, response);
    }

    private boolean authenticationNotRequired() {
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        return existingAuth != null && existingAuth.getPrincipal() instanceof SAMLPrincipal && existingAuth.isAuthenticated();
    }

    private boolean isSAML(HttpServletRequest request) {
        return StringUtils.hasText((String)request.getParameter("SAMLResponse")) || StringUtils.hasText((String)request.getParameter("SAMLRequest"));
    }
}

