/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.commons.io.IOUtils;

public class KeyStoreLocator {
    private static CertificateFactory certificateFactory;

    public KeyStore createKeyStore(String pemPassPhrase) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, pemPassPhrase.toCharArray());
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addPrivateKey(KeyStore keyStore, String alias, String privateKey, String certificate, String password) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException, CertificateException {
        String wrappedCert = this.wrapCert(certificate);
        byte[] decodedKey = Base64.getDecoder().decode(privateKey.getBytes());
        char[] passwordChars = password.toCharArray();
        Certificate cert = certificateFactory.generateCertificate(new ByteArrayInputStream(wrappedCert.getBytes()));
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        certs.add(cert);
        byte[] privKeyBytes = IOUtils.toByteArray((InputStream)new ByteArrayInputStream(decodedKey));
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(privKeyBytes);
        RSAPrivateKey privKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(ks);
        keyStore.setKeyEntry(alias, privKey, passwordChars, certs.toArray(new Certificate[certs.size()]));
    }

    public void addCertificate(KeyStore keyStore, String alias, String certificate) throws CertificateException, KeyStoreException {
        String wrappedCert = this.wrapCert(certificate);
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(wrappedCert.getBytes());
        Certificate cert = certificateFactory.generateCertificate(certificateInputStream);
        IOUtils.closeQuietly((InputStream)certificateInputStream);
        keyStore.setCertificateEntry(alias, cert);
    }

    private String wrapCert(String certificate) {
        return "-----BEGIN CERTIFICATE-----\n" + certificate + "\n-----END CERTIFICATE-----";
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

