/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import idensys.saml.NoProxySAMLPrincipal;
import idensys.saml.SAMLMessageHandler;
import idensys.saml.SAMLPrincipal;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class ProxyAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyAuthenticationSuccessHandler.class);
    private final SAMLMessageHandler samlMessageHandler;

    public ProxyAuthenticationSuccessHandler(SAMLMessageHandler samlMessageHandler) {
        this.samlMessageHandler = samlMessageHandler;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LOG.debug("Sending response for successful authentication {}", (Object)authentication);
        SAMLPrincipal principal = (SAMLPrincipal)authentication.getPrincipal();
        if (principal instanceof NoProxySAMLPrincipal) {
            response.sendRedirect("/test");
            return;
        }
        this.samlMessageHandler.sendAuthnResponse(principal, response);
    }
}

