/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import idensys.saml.SAMLPrincipal;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.springframework.security.core.AuthenticationException;

public class SAMLAuthenticationException
extends AuthenticationException {
    private final SAMLPrincipal principal;

    public SAMLAuthenticationException(String message, Exception exception, BasicSAMLMessageContext messageContext) {
        super(message, (Throwable)exception);
        AuthnRequest authnRequest = (AuthnRequest)messageContext.getInboundSAMLMessage();
        this.principal = new SAMLPrincipal(authnRequest.getProviderName(), authnRequest.getID(), authnRequest.getAssertionConsumerServiceURL(), messageContext.getRelayState());
    }

    public SAMLAuthenticationException(String message, Exception exception, SAMLPrincipal principal) {
        super(message, (Throwable)exception);
        this.principal = principal;
    }

    public SAMLPrincipal getPrincipal() {
        return this.principal;
    }
}

