/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import idensys.saml.SAMLAuthenticationException;
import idensys.saml.SAMLBuilder;
import idensys.saml.SAMLPrincipal;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SigningUtil;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;
import org.springframework.security.saml.key.KeyManager;

public class SAMLMessageHandler {
    private final KeyManager keyManager;
    private final SAMLMessageEncoder encoder;
    private final SAMLMessageDecoder decoder;
    private final SecurityPolicyResolver resolver;
    private final String entityId;
    private final List<ValidatorSuite> validatorSuites;

    public SAMLMessageHandler(KeyManager keyManager, SAMLMessageDecoder samlMessageDecoder, SAMLMessageEncoder samlMessageEncoder, SecurityPolicyResolver securityPolicyResolver, String entityId) {
        this.keyManager = keyManager;
        this.encoder = samlMessageEncoder;
        this.decoder = samlMessageDecoder;
        this.resolver = securityPolicyResolver;
        this.entityId = entityId;
        this.validatorSuites = Arrays.asList(Configuration.getValidatorSuite((String)"saml2-core-schema-validator"), Configuration.getValidatorSuite((String)"saml2-core-spec-validator"));
    }

    public SAMLMessageContext extractSAMLMessageContext(HttpServletRequest request) {
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(request));
        messageContext.setSecurityPolicyResolver(this.resolver);
        try {
            this.decoder.decode((MessageContext)messageContext);
        }
        catch (MessageDecodingException | SecurityException e) {
            throw new RuntimeException(e);
        }
        SAMLObject inboundSAMLMessage = messageContext.getInboundSAMLMessage();
        if (!(inboundSAMLMessage instanceof AuthnRequest)) {
            throw new RuntimeException("Expected inboundSAMLMessage to be AuthnRequest, but actual " + inboundSAMLMessage.getClass());
        }
        AuthnRequest authnRequest = (AuthnRequest)inboundSAMLMessage;
        try {
            this.validate(request, authnRequest);
        }
        catch (SecurityException | ValidationException e) {
            throw new SAMLAuthenticationException("Exception during validation of AuthnRequest (" + e.getMessage() + ")", (Exception)e, messageContext);
        }
        return messageContext;
    }

    public void sendAuthnResponse(SAMLPrincipal principal, HttpServletResponse response) {
        try {
            this.doSendAuthnResponse(principal, response, SAMLBuilder.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success"));
        }
        catch (MessageEncodingException | MarshallingException | SignatureException e) {
            throw new SAMLAuthenticationException("Exception during sending of AuthnResponse", (Exception)e, principal);
        }
    }

    public void sendFailedAuthnResponse(SAMLAuthenticationException authenticationException, HttpServletResponse response) throws MarshallingException, SignatureException, MessageEncodingException {
        this.doSendAuthnResponse(authenticationException.getPrincipal(), response, SAMLBuilder.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", authenticationException.getMessage()));
    }

    private void doSendAuthnResponse(SAMLPrincipal principal, HttpServletResponse response, Status status) throws MarshallingException, SignatureException, MessageEncodingException {
        Credential signingCredential = this.resolveCredential(this.entityId);
        Response authResponse = SAMLBuilder.buildSAMLObject(Response.class, Response.DEFAULT_ELEMENT_NAME);
        Issuer issuer = SAMLBuilder.buildIssuer(this.entityId);
        authResponse.setIssuer(issuer);
        authResponse.setID(UUID.randomUUID().toString());
        authResponse.setIssueInstant(new DateTime());
        authResponse.setInResponseTo(principal.getRequestID());
        Assertion assertion = SAMLBuilder.buildAssertion(principal, status, this.entityId);
        SAMLBuilder.signAssertion((SignableXMLObject)assertion, signingCredential);
        authResponse.getAssertions().add(assertion);
        authResponse.setDestination(principal.getAssertionConsumerServiceURL());
        authResponse.setStatus(status);
        Endpoint endpoint = SAMLBuilder.buildSAMLObject(Endpoint.class, SingleSignOnService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation(principal.getAssertionConsumerServiceURL());
        HttpServletResponseAdapter outTransport = new HttpServletResponseAdapter(response, false);
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setOutboundMessageTransport((OutTransport)outTransport);
        messageContext.setPeerEntityEndpoint(endpoint);
        messageContext.setOutboundSAMLMessage((SAMLObject)authResponse);
        messageContext.setOutboundSAMLMessageSigningCredential(signingCredential);
        messageContext.setOutboundMessageIssuer(this.entityId);
        messageContext.setRelayState(principal.getRelayState());
        this.encoder.encode((MessageContext)messageContext);
    }

    private void validate(HttpServletRequest request, AuthnRequest authnRequest) throws ValidationException, SecurityException {
        this.validateXMLObject((XMLObject)authnRequest);
        this.validateSignature(authnRequest);
        this.validateRawSignature(request, authnRequest.getIssuer().getValue());
    }

    private void validateXMLObject(XMLObject xmlObject) throws ValidationException {
        for (ValidatorSuite validatorSuite : this.validatorSuites) {
            validatorSuite.validate(xmlObject);
        }
    }

    private void validateRawSignature(HttpServletRequest request, String issuer) throws SecurityException {
        String base64signature = request.getParameter("Signature");
        String sigAlg = request.getParameter("SigAlg");
        if (base64signature == null || sigAlg == null) {
            return;
        }
        byte[] input = request.getQueryString().replaceFirst("&Signature[^&]+", "").getBytes();
        byte[] signature = Base64.decode((String)base64signature);
        Credential credential = this.resolveCredential(issuer);
        SigningUtil.verifyWithURI((Credential)credential, (String)sigAlg, (byte[])signature, (byte[])input);
    }

    private void validateSignature(AuthnRequest authnRequest) throws ValidationException {
        Signature signature = authnRequest.getSignature();
        if (signature == null) {
            return;
        }
        new SAMLSignatureProfileValidator().validate(signature);
        String issuer = authnRequest.getIssuer().getValue();
        Credential credential = this.resolveCredential(issuer);
        new SignatureValidator(credential).validate(signature);
    }

    private Credential resolveCredential(String entityId) {
        try {
            return (Credential)this.keyManager.resolveSingle((Object)new CriteriaSet((Criteria)new EntityIDCriteria(entityId)));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

