/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import idensys.saml.SAMLAttribute;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SAMLPrincipal
implements Principal {
    private final String serviceProviderEntityID;
    private final String requestID;
    private final String assertionConsumerServiceURL;
    private final String relayState;
    private final List<SAMLAttribute> attributes = new ArrayList<SAMLAttribute>();
    private String nameID;
    private String nameIDType;

    public SAMLPrincipal(String serviceProviderEntityID, String requestID, String assertionConsumerServiceURL, String relayState) {
        this.serviceProviderEntityID = serviceProviderEntityID;
        this.requestID = requestID;
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
        this.relayState = relayState;
    }

    public void elevate(String nameID, String nameIDType, List<SAMLAttribute> attributes) {
        this.nameID = nameID;
        this.nameIDType = nameIDType;
        this.attributes.addAll(attributes);
    }

    public String getServiceProviderEntityID() {
        return this.serviceProviderEntityID;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public List<SAMLAttribute> getAttributes() {
        return this.attributes;
    }

    public String getNameID() {
        return this.nameID;
    }

    public String getNameIDType() {
        return this.nameIDType;
    }

    @Override
    public String getName() {
        return this.nameID;
    }

    @Override
    public String toString() {
        return "SAMLPrincipal{attributes=" + this.attributes + ", serviceProviderEntityID='" + this.serviceProviderEntityID + '\'' + ", requestID='" + this.requestID + '\'' + ", assertionConsumerServiceURL='" + this.assertionConsumerServiceURL + '\'' + ", nameID='" + this.nameID + '\'' + ", relayState='" + this.relayState + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLPrincipal that = (SAMLPrincipal)o;
        return Objects.equals(this.nameID, that.nameID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nameID);
    }
}

