/*
 * Decompiled with CFR 0.152.
 */
package idensys.saml;

import idensys.saml.ServiceProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.springframework.core.io.Resource;

public class ServiceProviderFeedParser {
    private final Resource resource;

    public ServiceProviderFeedParser(Resource resource) {
        this.resource = resource;
    }

    public Map<String, ServiceProvider> parse() throws IOException, XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(this.resource.getInputStream());
        HashMap<String, ServiceProvider> serviceProviders = new HashMap<String, ServiceProvider>();
        String entityId = null;
        String signingCertificate = null;
        boolean isServiceProvider = false;
        boolean isSigning = false;
        ArrayList<String> assertionConsumerServiceURLs = null;
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "EntityDescriptor": {
                            entityId = reader.getAttributeValue(null, "entityID");
                            break block0;
                        }
                        case "SPSSODescriptor": {
                            isServiceProvider = true;
                            break block0;
                        }
                        case "KeyDescriptor": {
                            isSigning = "signing".equals(reader.getAttributeValue(null, "use"));
                            break block0;
                        }
                        case "X509Certificate": {
                            if (!isServiceProvider || !isSigning) break;
                            signingCertificate = reader.getElementText().replaceAll("\\s", "");
                            break block0;
                        }
                        case "AssertionConsumerService": {
                            if (assertionConsumerServiceURLs == null) {
                                assertionConsumerServiceURLs = new ArrayList<String>();
                            }
                            assertionConsumerServiceURLs.add(reader.getAttributeValue(null, "Location"));
                        }
                    }
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("EntityDescriptor") || !isServiceProvider) break;
                    serviceProviders.put(entityId, new ServiceProvider(entityId, signingCertificate, assertionConsumerServiceURLs));
                    entityId = null;
                    signingCertificate = null;
                    isServiceProvider = false;
                    isSigning = false;
                    assertionConsumerServiceURLs = null;
                }
            }
        }
        return serviceProviders;
    }
}

