/*
 * Decompiled with CFR 0.152.
 */
package idensys.web;

import idensys.saml.ConfigurableArtifactResolutionProfile;
import idensys.saml.CustomSAMLBootstrap;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.HTTPArtifactBinding;
import org.springframework.security.saml.processor.HTTPPAOS11Binding;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;
import org.springframework.security.saml.processor.SAMLBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.processor.SAMLProcessorImpl;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;

@Configuration
public class SAMLConfig {
    @Value(value="${idp.verify_host_name}")
    private boolean verifyHostName;

    @Bean
    public MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager() {
        return new MultiThreadedHttpConnectionManager();
    }

    @Bean
    public HttpClient httpClient() {
        return new HttpClient((HttpConnectionManager)this.multiThreadedHttpConnectionManager());
    }

    @Bean
    @Autowired
    public HTTPArtifactBinding artifactBinding(ParserPool parserPool, VelocityEngine velocityEngine, MetadataManager metadataManager) {
        return new HTTPArtifactBinding(parserPool, velocityEngine, this.artifactResolutionProfile(parserPool, metadataManager));
    }

    @Bean
    @Autowired
    public HTTPSOAP11Binding soapBinding(ParserPool parserPool) {
        return new HTTPSOAP11Binding(parserPool);
    }

    @Bean
    @Autowired
    public HTTPPostBinding httpPostBinding(ParserPool parserPool, VelocityEngine velocityEngine) {
        HTTPPostEncoder encoder = new HTTPPostEncoder(velocityEngine, "/templates/saml2-post-binding.vm");
        return new HTTPPostBinding(parserPool, (MessageDecoder)new HTTPPostDecoder(parserPool), (MessageEncoder)encoder);
    }

    @Bean
    @Autowired
    public HTTPRedirectDeflateBinding httpRedirectDeflateBinding(ParserPool parserPool) {
        return new HTTPRedirectDeflateBinding(parserPool);
    }

    @Bean
    @Autowired
    public HTTPSOAP11Binding httpSOAP11Binding(ParserPool parserPool) {
        return new HTTPSOAP11Binding(parserPool);
    }

    @Bean
    @Autowired
    public HTTPPAOS11Binding httpPAOS11Binding(ParserPool parserPool) {
        return new HTTPPAOS11Binding(parserPool);
    }

    @Autowired
    @Bean
    public SAMLProcessorImpl processor(VelocityEngine velocityEngine, ParserPool parserPool, MetadataManager metadataManager) {
        ArrayList<Object> bindings = new ArrayList<Object>();
        bindings.add(this.httpRedirectDeflateBinding(parserPool));
        bindings.add(this.httpPostBinding(parserPool, velocityEngine));
        bindings.add(this.artifactBinding(parserPool, velocityEngine, metadataManager));
        bindings.add(this.httpSOAP11Binding(parserPool));
        bindings.add(this.httpPAOS11Binding(parserPool));
        return new SAMLProcessorImpl(bindings);
    }

    @Bean
    public static SAMLBootstrap sAMLBootstrap() {
        return new CustomSAMLBootstrap();
    }

    @Bean
    public SAMLDefaultLogger samlLogger() {
        return new SAMLDefaultLogger();
    }

    @Bean
    public WebSSOProfileConsumer webSSOprofileConsumer() {
        return new WebSSOProfileConsumerImpl();
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOprofileConsumer() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    public WebSSOProfile webSSOprofile() {
        return new WebSSOProfileImpl();
    }

    @Bean
    public WebSSOProfileECPImpl ecpprofile() {
        return new WebSSOProfileECPImpl();
    }

    private ArtifactResolutionProfile artifactResolutionProfile(ParserPool parserPool, MetadataManager metadataManager) {
        ConfigurableArtifactResolutionProfile artifactResolutionProfile = new ConfigurableArtifactResolutionProfile(this.httpClient(), this.verifyHostName);
        artifactResolutionProfile.setProcessor((SAMLProcessor)new SAMLProcessorImpl((SAMLBinding)this.soapBinding(parserPool)));
        artifactResolutionProfile.setMetadata(metadataManager);
        return artifactResolutionProfile;
    }
}

