/*
 * Decompiled with CFR 0.152.
 */
package idensys.web;

import idensys.saml.DefaultMetadataDisplayFilter;
import idensys.saml.DefaultSAMLUserDetailsService;
import idensys.saml.IdentityProviderAuthnFilter;
import idensys.saml.KeyNamedJKSKeyManager;
import idensys.saml.KeyStoreLocator;
import idensys.saml.ProxiedSAMLContextProviderLB;
import idensys.saml.ProxyAuthenticationSuccessHandler;
import idensys.saml.ProxySAMLAuthenticationProvider;
import idensys.saml.ProxyURIComparator;
import idensys.saml.ResourceMetadataProvider;
import idensys.saml.SAMLMessageHandler;
import idensys.saml.ServiceProvider;
import idensys.saml.ServiceProviderFeedParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.Filter;
import javax.xml.stream.XMLStreamException;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.common.binding.security.MessageReplayRule;
import org.opensaml.saml2.binding.decoding.HTTPRedirectDeflateDecoder;
import org.opensaml.saml2.binding.encoding.HTTPPostSimpleSignEncoder;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.util.storage.MapBasedStorageService;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.saml.parser.ParserPoolHolder;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private Environment environment;
    @Value(value="${idp.metadata_url}")
    private String identityProviderMetadataUrl;
    @Value(value="${proxy.base_url}")
    private String idensysBaseUrl;
    @Value(value="${proxy.entity_id}")
    private String idensysEntityId;
    @Value(value="${proxy.private_key}")
    private String idensysPrivateKey;
    @Value(value="${proxy.certificate}")
    private String idensysCertificate;
    @Value(value="${proxy.passphrase}")
    private String idensysPassphrase;
    @Value(value="${proxy.acs_location}")
    private String idensysACSLocation;
    @Value(value="${serviceproviders.feed}")
    private String serviceProvidersFeedUrl;
    @Value(value="${serviceproviders.allow_unknown}")
    private boolean serviceProvidersAllowUnknown;
    @Value(value="${server.port}")
    private int serverPort;
    @Value(value="${proxy.key_name}")
    private String proxyKeyName;
    private DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
    private Map<String, ServiceProvider> serviceProviders;

    @Bean
    public SAMLAuthenticationProvider samlAuthenticationProvider() {
        ProxySAMLAuthenticationProvider samlAuthenticationProvider = new ProxySAMLAuthenticationProvider();
        samlAuthenticationProvider.setUserDetails(new DefaultSAMLUserDetailsService());
        samlAuthenticationProvider.setForcePrincipalAsString(false);
        samlAuthenticationProvider.setExcludeCredential(true);
        return samlAuthenticationProvider;
    }

    @Bean
    public SAMLEntryPoint samlEntryPoint() {
        WebSSOProfileOptions webSSOProfileOptions = new WebSSOProfileOptions();
        webSSOProfileOptions.setIncludeScoping(Boolean.valueOf(false));
        webSSOProfileOptions.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        SAMLEntryPoint samlEntryPoint = new SAMLEntryPoint();
        samlEntryPoint.setDefaultProfileOptions(webSSOProfileOptions);
        return samlEntryPoint;
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/health", "/info", "/service/catalog"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.identityProviderAuthnFilter()).and()).csrf().disable()).addFilterBefore((Filter)this.metadataGeneratorFilter(), ChannelProcessingFilter.class).addFilterAfter((Filter)this.samlFilter(), BasicAuthenticationFilter.class).authorizeRequests().antMatchers(new String[]{"/saml/idp/**", "/sp/metadata", "/saml/SSO/**", "/idp/metadata"})).permitAll().anyRequest()).hasRole("USER");
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider());
    }

    @Bean
    public MetadataDisplayFilter metadataDisplayFilter() {
        DefaultMetadataDisplayFilter displayFilter = new DefaultMetadataDisplayFilter();
        displayFilter.setFilterProcessesUrl("sp/metadata");
        return displayFilter;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler authenticationFailureHandler() {
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setUseForward(true);
        failureHandler.setDefaultFailureUrl("/error");
        return failureHandler;
    }

    @Bean
    @Autowired
    public SAMLProcessingFilter samlWebSSOProcessingFilter() throws Exception {
        SAMLProcessingFilter samlWebSSOProcessingFilter = new SAMLProcessingFilter();
        samlWebSSOProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlWebSSOProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new ProxyAuthenticationSuccessHandler(this.samlMessageHandler()));
        samlWebSSOProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.authenticationFailureHandler());
        return samlWebSSOProcessingFilter;
    }

    @Bean
    @Autowired
    public MetadataGeneratorFilter metadataGeneratorFilter() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, XMLStreamException {
        return new MetadataGeneratorFilter(this.metadataGenerator());
    }

    @Bean
    public FilterChainProxy samlFilter() throws Exception {
        ArrayList<DefaultSecurityFilterChain> chains = new ArrayList<DefaultSecurityFilterChain>();
        chains.add(this.chain("/saml/idp/**", (Filter)this.identityProviderAuthnFilter()));
        chains.add(this.chain("/saml/login/**", (Filter)this.samlEntryPoint()));
        chains.add(this.chain("/sp/metadata/**", (Filter)this.metadataDisplayFilter()));
        chains.add(this.chain("/saml/SSO/**", (Filter)this.samlWebSSOProcessingFilter()));
        return new FilterChainProxy(chains);
    }

    @Bean
    public IdentityProviderAuthnFilter identityProviderAuthnFilter() throws NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, KeyStoreException, IOException, XMLStreamException {
        return new IdentityProviderAuthnFilter(this.samlMessageHandler(), this.serviceProviders, this.serviceProvidersAllowUnknown, this.environment);
    }

    private DefaultSecurityFilterChain chain(String pattern, Filter entryPoint) {
        return new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher(pattern), new Filter[]{entryPoint});
    }

    @Bean
    public ExtendedMetadata extendedMetadata() {
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setIdpDiscoveryEnabled(false);
        extendedMetadata.setSignMetadata(true);
        extendedMetadata.setTlsKey(this.idensysEntityId);
        extendedMetadata.setSigningAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        return extendedMetadata;
    }

    @Bean
    public MetadataProvider identityProvider() throws MetadataProviderException {
        Resource resource = this.defaultResourceLoader.getResource(this.identityProviderMetadataUrl);
        ResourceMetadataProvider resourceMetadataProvider = new ResourceMetadataProvider(resource);
        resourceMetadataProvider.setParserPool(this.parserPool());
        ExtendedMetadataDelegate extendedMetadataDelegate = new ExtendedMetadataDelegate((MetadataProvider)resourceMetadataProvider, this.extendedMetadata());
        extendedMetadataDelegate.setMetadataTrustCheck(true);
        extendedMetadataDelegate.setMetadataRequireSignature(true);
        return extendedMetadataDelegate;
    }

    @Bean
    @Qualifier(value="metadata")
    public CachingMetadataManager metadata() throws MetadataProviderException {
        ArrayList<MetadataProvider> providers = new ArrayList<MetadataProvider>();
        providers.add(this.identityProvider());
        CachingMetadataManager metadataManager = new CachingMetadataManager(providers);
        metadataManager.setRefreshCheckInterval(3600000L);
        return metadataManager;
    }

    @Bean
    public VelocityEngine velocityEngine() {
        return VelocityFactory.getEngine();
    }

    @Bean(initMethod="initialize")
    public ParserPool parserPool() {
        return new StaticBasicParserPool();
    }

    @Bean(name={"parserPoolHolder"})
    public ParserPoolHolder parserPoolHolder() {
        return new ParserPoolHolder();
    }

    @Bean
    public SAMLContextProviderImpl contextProvider() throws URISyntaxException {
        return new ProxiedSAMLContextProviderLB(new URI(this.idensysBaseUrl));
    }

    @Bean
    public MetadataGenerator metadataGenerator() throws NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, KeyStoreException, IOException, XMLStreamException {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setEntityId(this.idensysEntityId);
        metadataGenerator.setEntityBaseURL(this.idensysBaseUrl);
        metadataGenerator.setExtendedMetadata(this.extendedMetadata());
        metadataGenerator.setIncludeDiscoveryExtension(false);
        metadataGenerator.setKeyManager(this.keyManager());
        if (this.environment.acceptsProfiles(new String[]{"dev"})) {
            metadataGenerator.setWantAssertionSigned(false);
        }
        return metadataGenerator;
    }

    @Bean
    public KeyManager keyManager() throws InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, XMLStreamException {
        KeyStoreLocator keyStoreLocator = new KeyStoreLocator();
        KeyStore keyStore = keyStoreLocator.createKeyStore(this.idensysPassphrase);
        keyStoreLocator.addPrivateKey(keyStore, this.idensysEntityId, this.idensysPrivateKey, this.idensysCertificate, this.idensysPassphrase);
        this.serviceProviders = this.getServiceProviders();
        this.serviceProviders.entrySet().forEach(sp -> {
            try {
                ServiceProvider serviceProvider = (ServiceProvider)sp.getValue();
                if (serviceProvider.isSigningCertificateSigned() && !serviceProvider.getEntityId().equals(this.idensysEntityId)) {
                    keyStoreLocator.addCertificate(keyStore, (String)sp.getKey(), serviceProvider.getSigningCertificate());
                }
            }
            catch (KeyStoreException | CertificateException e) {
                throw new RuntimeException(e);
            }
        });
        return new KeyNamedJKSKeyManager(keyStore, Collections.singletonMap(this.idensysEntityId, this.idensysPassphrase), this.idensysEntityId, this.proxyKeyName);
    }

    private Map<String, ServiceProvider> getServiceProviders() throws IOException, XMLStreamException {
        if (this.serviceProviders == null) {
            this.serviceProviders = new ServiceProviderFeedParser(this.defaultResourceLoader.getResource(this.serviceProvidersFeedUrl)).parse();
        }
        if (this.environment.acceptsProfiles(new String[]{"dev"})) {
            this.serviceProviders.put(this.idensysEntityId, new ServiceProvider(this.idensysEntityId, this.idensysCertificate, Collections.singletonList(this.idensysACSLocation)));
        }
        return this.serviceProviders;
    }

    @Bean
    public SAMLMessageHandler samlMessageHandler() throws NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, KeyStoreException, IOException, XMLStreamException {
        HTTPRedirectDeflateDecoder samlMessageDecoder = new HTTPRedirectDeflateDecoder(this.parserPool());
        samlMessageDecoder.setURIComparator((URIComparator)new ProxyURIComparator(this.idensysBaseUrl, "http://localhost:" + this.serverPort));
        return new SAMLMessageHandler(this.keyManager(), (SAMLMessageDecoder)samlMessageDecoder, (SAMLMessageEncoder)new HTTPPostSimpleSignEncoder(this.velocityEngine(), "/templates/saml2-post-simplesign-binding.vm", true), this.securityPolicyResolver(), this.idensysEntityId);
    }

    private SecurityPolicyResolver securityPolicyResolver() {
        IssueInstantRule instantRule = new IssueInstantRule(90, 300);
        MessageReplayRule replayRule = new MessageReplayRule(new ReplayCache((StorageService)new MapBasedStorageService(), 14400000L));
        BasicSecurityPolicy securityPolicy = new BasicSecurityPolicy();
        securityPolicy.getPolicyRules().addAll(Arrays.asList(instantRule, replayRule));
        return new StaticSecurityPolicyResolver((SecurityPolicy)securityPolicy);
    }
}

