/*
 * Decompiled with CFR 0.152.
 */
package intake.api;

import intake.exception.NoScopedAffiliationException;
import intake.model.Course;
import intake.model.Institution;
import intake.model.Registration;
import intake.repository.CatalogRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/intake/api"}, produces={"application/json"})
public class Education {
    private static final Log LOG = LogFactory.getLog(Education.class);
    private final CatalogRepository catalogRepository;

    public Education(CatalogRepository catalogRepository) {
        this.catalogRepository = catalogRepository;
    }

    @GetMapping(value={"/public/institutions"})
    public List<Institution> institutions() {
        return this.catalogRepository.institutions();
    }

    @GetMapping(value={"/public/institutions-schac-home"})
    public List<String> institutionsSchacHomes() {
        return this.catalogRepository.institutions().stream().map(Institution::getSchacHome).collect(Collectors.toList());
    }

    @GetMapping(value={"/public/institution"})
    public Institution findInstitutionBySchacHome(@RequestParam(value="schac_home") String schacHome) {
        return this.catalogRepository.findInstitutionBySchacHome(schacHome);
    }

    @GetMapping(value={"/public/course"})
    public Course findCourseByIdentifier(@RequestParam(value="identifier") String identifier) {
        return this.catalogRepository.findCourseByIdentifier(identifier);
    }

    @PutMapping(value={"/private/register"})
    public ResponseEntity register(Authentication authentication, @RequestBody Registration registration) {
        LOG.info((Object)String.format("Registration %s URL for  %s", registration, authentication.getPrincipal()));
        List eduPersonScopedAffiliations = ((DefaultOidcUser)authentication.getPrincipal()).getAttributes().getOrDefault("eduperson_scoped_affiliation", new ArrayList());
        eduPersonScopedAffiliations.stream().filter(aff -> aff.endsWith(registration.getSchacHomeInstitution())).findFirst().orElseThrow(NoScopedAffiliationException::new);
        Course course = this.catalogRepository.findCourseByIdentifier(registration.getCourseIdentifier());
        Institution homeInstitution = this.catalogRepository.findInstitutionBySchacHome(registration.getSchacHomeInstitution());
        Institution guestInstitution = this.catalogRepository.findInstitutionBySchacHome(registration.getSchacHomeGuestInstitution());
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)guestInstitution.getApiBaseUrl());
        builder.queryParam("course", new Object[]{course.getIdentifier()});
        builder.queryParam("scope", new Object[]{course.getRequiredScopes().stream().collect(Collectors.joining(" "))});
        builder.queryParam("apiUrl", new Object[]{homeInstitution.getApiBaseUrl()});
        return registration.isPreview() ? ResponseEntity.ok(Collections.singletonMap("url", builder.build().toUriString())) : ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(builder.build().toUri())).build();
    }
}

