/*
 * Decompiled with CFR 0.152.
 */
package intake.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/intake/api"})
public class User {
    private final Map<String, String> config = new HashMap();

    public User(@Value(value="${config.client_url}") String clientUrl, @Value(value="${config.server_login}") String serverLogin) {
        this.config.put("client_url", clientUrl);
        this.config.put("server_login", serverLogin);
    }

    @GetMapping(value={"/public/config"})
    public ResponseEntity config() {
        return ResponseEntity.ok((Object)this.config);
    }

    @GetMapping(value={"/private/sso"})
    public ResponseEntity sso(@RequestParam(value="location", required=false, defaultValue="/") String location) throws URISyntaxException {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(new URI((String)this.config.get("client_url") + location))).build();
    }

    @GetMapping(value={"/private/me"})
    public ResponseEntity me(Authentication authentication) {
        Map attributes = ((DefaultOidcUser)authentication.getPrincipal()).getAttributes();
        return ResponseEntity.ok((Object)attributes);
    }

    @GetMapping(value={"/private/logout"})
    public ResponseEntity logout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.invalidate();
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        return ResponseEntity.ok(Collections.singletonMap("status", "ok"));
    }
}

